/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Application Loader
 *
 *  This loads the driver to take over the operating system!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Copyright (c) 2005, All Rights Reserved
 **********************************************************************/



#include <windows.h>
#include <WINIOCTL.H>
#include <stdio.h>

/*
 * Should put this in a sharable header file.
 */
#define IOCTL_EXECUTE_64_BIT_CODE     CTL_CODE(FILE_DEVICE_UNKNOWN, 0x802, METHOD_BUFFERED, FILE_READ_DATA | FILE_WRITE_DATA)


unsigned char * MutinyApp_ReadFile(char *pszFileName, unsigned int *puiCodeSize)
{
    unsigned char *pApplicationCode = NULL;
    DWORD dwLowFileSize, dwHighFileSize, dwIndex, dwBytesRead, dwLoopIndex;
    HANDLE hFile; 

    hFile = CreateFile(pszFileName, GENERIC_READ, 0, NULL, OPEN_EXISTING, 0, NULL);

    if(hFile && hFile != INVALID_HANDLE_VALUE)
    {
       dwLowFileSize = GetFileSize(hFile, &dwHighFileSize);
       *puiCodeSize =  dwLowFileSize;

       pApplicationCode = LocalAlloc(LMEM_ZEROINIT, dwLowFileSize);

       if(pApplicationCode)
       {
           dwIndex = 0;
           dwLoopIndex = dwLowFileSize;

           while(dwLoopIndex > 1000)
           {
               ReadFile(hFile, pApplicationCode + dwIndex, 1000, &dwBytesRead, NULL);

               dwLoopIndex = dwLoopIndex - dwBytesRead;
               dwIndex = dwIndex + dwBytesRead;
           }

           if(dwLoopIndex)
           {
               ReadFile(hFile, pApplicationCode + dwIndex, dwLoopIndex, &dwBytesRead, NULL);
           }

       }

       CloseHandle(hFile);

    }

    return  pApplicationCode;
}



/*********************************************************
 *   Main Function Entry
 *
 *********************************************************/
int _cdecl main(int argc, char **argv)
{
    HANDLE hSCManager;
    HANDLE hService;
    SERVICE_STATUS ss;
    unsigned char *pucApplicationCode = NULL;
    unsigned int uiCodeSize = 0;
    DWORD dwReturnBytes;

    if(argc == 2)
    {

        pucApplicationCode = MutinyApp_ReadFile(argv[1], &uiCodeSize);

        if(pucApplicationCode)
        {
            hSCManager = OpenSCManager(NULL, NULL, SC_MANAGER_CREATE_SERVICE);
            
            printf("Attempting to load the driver...\n");
        
            if(hSCManager)
            {
                printf("Creating the driver as a service (NT Style)...\n");
        
                hService = CreateService(hSCManager, "Mutiny", "Mutiny Driver", SERVICE_START | DELETE | SERVICE_STOP, SERVICE_KERNEL_DRIVER, SERVICE_DEMAND_START, SERVICE_ERROR_IGNORE, "C:\\mutinydrv.sys", NULL, NULL, NULL, NULL, NULL);
        
                if(!hService)
                {
                    printf("Service already created open existing service...\n");
                    hService = OpenService(hSCManager, "Mutiny", SERVICE_START | DELETE | SERVICE_STOP);
                }
        
                if(hService)
                {
                    HANDLE hMutinyDriverHandle;
        
                    printf("Starting the service... \n");                                 
        
                    StartService(hService, 0, NULL);
                    
                    printf("Opening the driver... \n");
        
                    hMutinyDriverHandle = CreateFile("\\\\.\\Mutiny", GENERIC_READ | GENERIC_WRITE, 0, NULL, OPEN_EXISTING, 0, NULL);
        
                    if(hMutinyDriverHandle == INVALID_HANDLE_VALUE)
                    {
                        printf("Opening the driver failed (%0x)... \n", GetLastError());
                    }
                    else
                    {
                       printf("Executing 64bit Application\n");
                       DeviceIoControl(hMutinyDriverHandle, IOCTL_EXECUTE_64_BIT_CODE, pucApplicationCode, uiCodeSize, NULL, 0, &dwReturnBytes, NULL);
        
                       printf("Closing the driver... \n");
                       CloseHandle(hMutinyDriverHandle);
                    }
        
                    printf("Stopping the service & Cleaning up... \n");
                    
                    ControlService(hService, SERVICE_CONTROL_STOP, &ss);
                    
                    DeleteService(hService);
        
                    CloseServiceHandle(hService);
        
                }
                else
                {
                    printf("Creating/Opening the service failed (%0x)... \n", GetLastError());
                }
        
                CloseServiceHandle(hSCManager);
            }
            else
            {
                printf("Opening the service control manager failed (%0x)... \n", GetLastError());
            }

            LocalFree(pucApplicationCode);
        }
    }
    else
    {
        printf("Usage: MUTINYAPP <binary file>\n");
        printf(" Non-PAE not supported yet, ensure your system is using PAE.\n");
        printf(" by adding /PAE to the BOOT.INI\n");
    }

    return 0;
}


