/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Driver!
 *
 *  This driver implements Operating System Mutiny!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Entry Point  Copyright (c) 2005, All Rights Reserved
 **********************************************************************/
#define _X86_

#include <wdm.h>
#include "mutiny.h"

typedef unsigned int UINT;
    
VOID Mutiny_Unload(PDRIVER_OBJECT  DriverObject);    
NTSTATUS DriverEntry(PDRIVER_OBJECT  pDriverObject, PUNICODE_STRING  pRegistryPath); 

#pragma alloc_text(INIT, DriverEntry)
#pragma alloc_text(PAGE, Mutiny_Unload)


/**********************************************************************
 * 
 *  DriverEntry
 *
 *    This is the default entry point for drivers.  The parameters
 *    are a driver object and the registry path.
 *
 **********************************************************************/
NTSTATUS DriverEntry(PDRIVER_OBJECT  pDriverObject, PUNICODE_STRING  pRegistryPath)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    UINT uiIndex = 0;
    PDEVICE_OBJECT pDeviceObject = NULL;
    UNICODE_STRING usDriverName, usDosDeviceName;

    DbgPrint("DriverEntry Called \r\n");

    RtlInitUnicodeString(&usDriverName, L"\\Device\\Mutiny");
    RtlInitUnicodeString(&usDosDeviceName, L"\\DosDevices\\Mutiny"); 

    NtStatus = IoCreateDevice(pDriverObject, 0, &usDriverName, FILE_DEVICE_UNKNOWN, FILE_DEVICE_SECURE_OPEN, FALSE, &pDeviceObject);

    if(NtStatus == STATUS_SUCCESS)
    {

        for(uiIndex = 0; uiIndex < IRP_MJ_MAXIMUM_FUNCTION; uiIndex++)
             pDriverObject->MajorFunction[uiIndex] = Mutiny_UnSupportedFunction;
    
        pDriverObject->MajorFunction[IRP_MJ_CLOSE]           = Mutiny_Close;
        pDriverObject->MajorFunction[IRP_MJ_DEVICE_CONTROL]  = Mutiny_DeviceControl;
        pDriverObject->MajorFunction[IRP_MJ_CREATE]          = Mutiny_Create;
    
        pDriverObject->DriverUnload =  Mutiny_Unload;

   
        pDeviceObject->Flags &= (~DO_DEVICE_INITIALIZING);
    
        IoCreateSymbolicLink(&usDosDeviceName, &usDriverName);
 
    }


    return NtStatus;
}


/**********************************************************************
 * 
 *  Mutiny_Unload
 *
 *    This is an optional unload function which is called when the
 *    driver is unloaded.
 *
 **********************************************************************/
VOID Mutiny_Unload(PDRIVER_OBJECT  DriverObject)
{    
    
    UNICODE_STRING usDosDeviceName;
    
    DbgPrint("Mutiny_Unload Called \r\n");
    
    RtlInitUnicodeString(&usDosDeviceName, L"\\DosDevices\\Mutiny");
    IoDeleteSymbolicLink(&usDosDeviceName);

    IoDeleteDevice(DriverObject->DeviceObject);
}


