/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Driver!
 *
 *  This driver implements Operating System Mutiny!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Entry Point  Copyright (c) 2005, All Rights Reserved
 **********************************************************************/


#define _X86_

#include <wdm.h>
#include "privatedata.h"


#define SELECTOR_TO_DESCRIPTOR_INDEX(x) (x>>3)
#define IDT_MAX_ENTRIES                  256


extern IDT_GATE_DESCRIPTOR_ENTRY g_64BitInterruptDescriptorTable[IDT_MAX_ENTRIES];

/*
 * Internal Functions
 */
NTSTATUS IDT_PopulateGlobalIDT64(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
void IDT_CreateDefaultDescriptorEntry(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState, unsigned short usSelectorIndex);
NTSTATUS IDT_PopulateTrapAndExceptionHandlers(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS IDT_InsertHardwareHandlers(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);


/**********************************************************************
 * 
 *  IDT_Setup64BitInterruptDescriptorTable
 *
 *    This API will implement 64 bit interrupt descriptor table
 *
 **********************************************************************/
NTSTATUS IDT_Setup64BitInterruptDescriptorTable(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{   
    NTSTATUS NtStatus = STATUS_SUCCESS;

    IDT_PopulateGlobalIDT64(pOperatingSystemThunkState);
    IDT_PopulateTrapAndExceptionHandlers(pOperatingSystemThunkState);
    IDT_InsertHardwareHandlers(pOperatingSystemThunkState);

    return NtStatus;
}

/**********************************************************************
 * 
 *  IDT_PopulateGlobalIDT64
 *
 *    This API will populate the global 64 bit IDT
 *
 *
 **********************************************************************/
NTSTATUS IDT_PopulateGlobalIDT64(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    unsigned short usInterruptSelectorIndex = 0, usIndex = 0;

    while(usIndex < IDT_MAX_ENTRIES)
    {
       IDT_CreateDefaultDescriptorEntry(pOperatingSystemThunkState, usInterruptSelectorIndex);

       usInterruptSelectorIndex += 0x8;
       usIndex++;
    }
        
    return NtStatus;
}

/**********************************************************************
 * 
 *  IDT_PopulateTrapAndExceptionHandlers
 *
 *    This API will insert the special trap & execption handlers
 *     into the IDT
 *
 *
 **********************************************************************/
NTSTATUS IDT_PopulateTrapAndExceptionHandlers(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
        
    return NtStatus;
}


/**********************************************************************
 * 
 *  IDT_InsertHardwareHandlers
 *
 *    This API will insert the hardware handlers
 *     into the IDT that we will be supporting.
 *                   
 *
 **********************************************************************/
NTSTATUS IDT_InsertHardwareHandlers(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{                                              
    NTSTATUS NtStatus = STATUS_SUCCESS;
        
    return NtStatus;
}






/**********************************************************************
 * 
 *  IDT_CreateDescriptorEntry
 *
 *    This API will put a descriptor into the descriptor table
 *
 **********************************************************************/
void IDT_CreateDefaultDescriptorEntry(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState, unsigned short usSelectorIndex)
{
    IDT_GATE_DESCRIPTOR_ENTRY IdtDefaultGateDescriptorEntry = {0};

    g_64BitInterruptDescriptorTable[SELECTOR_TO_DESCRIPTOR_INDEX(usSelectorIndex)] = IdtDefaultGateDescriptorEntry;
}

/**********************************************************************
 * 
 *  IDT_Free64BitInterruptDescriptorTable
 *
 *    This API will free 64 bit global descriptor table
 *
 **********************************************************************/
NTSTATUS IDT_Free64BitInterruptDescriptorTable(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    /*
     * Nothing to free
     */
    return STATUS_SUCCESS;
}


/* 
 * This is the 64 bit Interrupt Descriptor Table
 *
 */
IDT_GATE_DESCRIPTOR_ENTRY g_64BitInterruptDescriptorTable[IDT_MAX_ENTRIES] =
{
    0
  /* { 0,    0,     0,     0,     0,     0 },  NULL Desctiptor Entry */
};
