/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Implementation
 *
 *  This driver implements Operating System Mutiny!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Entry Point  Copyright (c) 2005, All Rights Reserved
 **********************************************************************/
#define _X86_

#include <ddk\ntddk.h>
#include "memory.h"




/**********************************************************************
 * 
 *  Memory_AllocateNonPaged4kAligned
 *
 *    This API will allocate 4k aligned non-paged memory
 *    from the Operating System.
 *
 *    I NEED THIS MEMORY PHYSICALLY ALIGNED!!!!
 *
 **********************************************************************/
NTSTATUS Memory_AllocateNonPaged4kPhysicallyAligned(UINT32 uiNumberOfPages, PMEMORY_BLOCK pMemoryBlock)
{
    PVOID pAllocatedMemory = NULL;
    PHYSICAL_ADDRESS PhsyicalAddress = { 0xFFFFFFFF };
    NTSTATUS NtStatus = STATUS_UNSUCCESSFUL;
    UINT32 uiMemorySize;

    if(pMemoryBlock->pAllocatedVirtualMemory = (PVOID)MmAllocateContiguousMemory((SIZE_T)uiNumberOfPages*4096, PhsyicalAddress))
    {
        memset(pMemoryBlock->pAllocatedVirtualMemory, 0, uiNumberOfPages*4096);

        pMemoryBlock->uiVirtualBlockSize      = uiNumberOfPages*4096;
        PhsyicalAddress                       = MmGetPhysicalAddress(pMemoryBlock->pAllocatedVirtualMemory);
        
        pMemoryBlock->PhysicalAddress = (unsigned int)PhsyicalAddress.QuadPart;

        if(pMemoryBlock->PhysicalAddress & 0xFFF)
        {
            pMemoryBlock->Aligned4kPhysicalAddress = (pMemoryBlock->PhysicalAddress & 0xFFFFF000) + 0x1000;

            if(pMemoryBlock->Aligned4kPhysicalAddress > pMemoryBlock->PhysicalAddress + pMemoryBlock->uiVirtualBlockSize)
            {
                MmFreeContiguousMemory(pMemoryBlock->pAllocatedVirtualMemory);
            }
            else
            {
                uiMemorySize = pMemoryBlock->Aligned4kPhysicalAddress - pMemoryBlock->PhysicalAddress;

                pMemoryBlock->uiPageAlignedBlockSize             =  pMemoryBlock->uiVirtualBlockSize - uiMemorySize;
                pMemoryBlock->pVirtualMappingOf4kPhysicalAddress =  (PVOID)(((unsigned char *)pMemoryBlock->pAllocatedVirtualMemory) + uiMemorySize);
                
                NtStatus = STATUS_SUCCESS;
            }

        }
        else
        {
            NtStatus = STATUS_SUCCESS;

            pMemoryBlock->Aligned4kPhysicalAddress = pMemoryBlock->PhysicalAddress;
            pMemoryBlock->uiPageAlignedBlockSize   = pMemoryBlock->uiVirtualBlockSize;

            pMemoryBlock->pVirtualMappingOf4kPhysicalAddress =  pMemoryBlock->pAllocatedVirtualMemory;

        }

    }
    

    return NtStatus;
}

/**********************************************************************
 * 
 *  Memory_FreeNonPaged4kAligned
 *
 *    This API will free memory allocated.
 *
 **********************************************************************/
void Memory_FreeNonPaged4kAligned(PMEMORY_BLOCK pMemoryBlock)
{
    MmFreeContiguousMemory(pMemoryBlock->pAllocatedVirtualMemory);
}












