/**********************************************************************
 * 
 *  Toby Opferman
 *
 *  Mutiny Driver!
 *
 *  This driver implements Operating System Mutiny!
 *  
 *  This example is for educational purposes only.  I license this source
 *  out for use in learning how to write a device driver.
 *
 *     Driver Entry Point  Copyright (c) 2005, All Rights Reserved
 **********************************************************************/


#define _X86_

#include <ddk/ntddk.h>
#include "privatedata.h"

#define PHYSICAL_ADDRESS_TO_4K_BOUNDARY(h, l, a) \
               l = ((a>>8) & 0xFFF0);  \
               h = ((a>>24) & 0xFF);
               
#define PHYSICAL_ADDRESS_TO_4K_BOUNDARY_PAE64_STYLE(h, l, a) \
               l = ((a>>8) & 0xFFFFFFF0);  \
               h = ((0));   



/*
 * Internal Functions
 */
NTSTATUS Paging64_AllocatePML4(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);
NTSTATUS Paging64_CreateCR3_32_PML4(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);  
NTSTATUS Paging64_AllocateOurOwnPDP(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState);


/**********************************************************************
 * 
 *  Paging64_CreatePageTables
 *
 *    This API will Create a page table 
 *    in 64 bit
 *
 **********************************************************************/
NTSTATUS Paging64_CreatePageTables(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{   
    NTSTATUS NtStatus = STATUS_NOT_IMPLEMENTED;

    /*
     * Not Implemented.  We are going to reuse all the crap from 32 bit PAE
     */
    return NtStatus;
}



/**********************************************************************
 * 
 *  Paging64_Map32BitPaeTo64BitPML4
 *
 *    This API will Create a 64 bit page table based on 32 bit PAE. 
 *    
 *
 **********************************************************************/
NTSTATUS Paging64_Map32BitPaeTo64BitPML4(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{   
    NTSTATUS NtStatus = STATUS_SUCCESS;    

    /*
     * Allocate the PDP.
     */
#if 0
    pOperatingSystemThunkState->PageTables64.pPageDirectoryPointerTable = (PPAGETABLE_PDP_ENTRY_PAE32)pOperatingSystemThunkState->PAEPageTables32.OSAllocatedMemoryBlock.pVirtualMappingOf4kPhysicalAddress;
    pOperatingSystemThunkState->PageTables64.pPhysicalAddressOfPDP      = pOperatingSystemThunkState->PAEPageTables32.OSAllocatedMemoryBlock.Aligned4kPhysicalAddress;
#else
    Paging64_AllocateOurOwnPDP(pOperatingSystemThunkState);
#endif

    /*
     * We simply want to allocate memory from the pool we created in PAE
     * for our PML4 Table.  We then just want to point the 0 entry
     * of the PML4 Table to our PDP Table we used in PAE32.
     */
    Paging64_AllocatePML4(pOperatingSystemThunkState);


    /*
     * Create our own CR3 32 bit to point to our PML4
     */
    Paging64_CreateCR3_32_PML4(pOperatingSystemThunkState);



    return NtStatus;
}


/**********************************************************************
 * 
 *  Paging64_AllocateOurOwnPDP
 *
 * Allocate our own PDP
 **********************************************************************/
NTSTATUS Paging64_AllocateOurOwnPDP(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PVOID pPhysicalAdddressOfPDP = NULL;
    PVOID pVirtualAdddressOfPDP = NULL;
    PHYSICAL_ADDRESS PhysicalAddress = {0};
    unsigned int uiIndex = 0;
    PPAGETABLE_PDP_ENTRY_PAE32 pPageTablePdp = NULL;

    pOperatingSystemThunkState->PAEPageTables32.uiLastPageIndexAllocated++;

    pPhysicalAdddressOfPDP = (PVOID)((unsigned char *)pOperatingSystemThunkState->PAEPageTables32.OSAllocatedMemoryBlock.Aligned4kPhysicalAddress + (pOperatingSystemThunkState->PAEPageTables32.uiLastPageIndexAllocated<<12));
    pVirtualAdddressOfPDP  = (PVOID)((unsigned char *)pOperatingSystemThunkState->PAEPageTables32.OSAllocatedMemoryBlock.pVirtualMappingOf4kPhysicalAddress + (pOperatingSystemThunkState->PAEPageTables32.uiLastPageIndexAllocated<<12));

    pOperatingSystemThunkState->PageTables64.pPageDirectoryPointerTable = (PPAGETABLE_PDP_ENTRY_PAE32)pVirtualAdddressOfPDP;
    pOperatingSystemThunkState->PageTables64.pPhysicalAddressOfPDP      = pPhysicalAdddressOfPDP;
    
    pPageTablePdp = (PPAGETABLE_PDP_ENTRY_PAE32)pOperatingSystemThunkState->PAEPageTables32.OSAllocatedMemoryBlock.pVirtualMappingOf4kPhysicalAddress;

    uiIndex = 0;
    while(uiIndex < 4)
    {
        pOperatingSystemThunkState->PageTables64.pPageDirectoryPointerTable[uiIndex] = pPageTablePdp[uiIndex];

        pOperatingSystemThunkState->PageTables64.pPageDirectoryPointerTable[uiIndex].bPagingAttributes = PAGING64_FLAG_IS_PRESENT | PAGING64_FLAG_WRITABLE;

        uiIndex++;
    }

    return NtStatus;
}

/**********************************************************************
 * 
 *  Paging64_CreateCR3_32_PML4
 *
 * Create our own CR3 32 bit to point to our PML4
 **********************************************************************/
NTSTATUS Paging64_CreateCR3_32_PML4(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{ 
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PHYSICAL_ADDRESS PhysicalAddress = {0};

    PHYSICAL_ADDRESS_TO_4K_BOUNDARY(pOperatingSystemThunkState->PageTables64.CR3_32bit.bTopPhysicalAddress, pOperatingSystemThunkState->PageTables64.CR3_32bit.wPhysicalAddressLowNibbleReserved, (unsigned int)pOperatingSystemThunkState->PageTables64.pPhysicalAddressOfPML4);
    PhysicalAddress = MmGetPhysicalAddress(pOperatingSystemThunkState->PageTables64.pPageTablePML4Entry);

    DbgPrint(" 64 Bit Paging PML4 Table Creation \n");
    DbgPrint("   Physical Address of PML4 (%0x, What we said it was %0x)  \n",(unsigned int)PhysicalAddress.QuadPart, pOperatingSystemThunkState->PageTables64.pPhysicalAddressOfPML4);
    DbgPrint("   Virtual Address of PML4 (%0x) \n", pOperatingSystemThunkState->PageTables64.pPageTablePML4Entry);
    DbgPrint("   CR3 = %0x%0x00 \n", pOperatingSystemThunkState->PageTables64.CR3_32bit.bTopPhysicalAddress, pOperatingSystemThunkState->PageTables64.CR3_32bit.wPhysicalAddressLowNibbleReserved);

    return NtStatus;
}


/**********************************************************************
 * 
 *  Paging64_AllocatePML4
 *
 * We simply want to allocate memory from the pool we created in PAE
 * for our PML4 Table.  We then just want to point the 0 entry
 * of the PML4 Table to our PDP Table we used in PAE32.
 *
 *    
 *
 **********************************************************************/
NTSTATUS Paging64_AllocatePML4(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState)
{   
    NTSTATUS NtStatus = STATUS_SUCCESS;
    PPAGETABLE_PML4_ENTRY64 pPageTablePML4Entry = NULL;
    PVOID pPhysicalAdddressOfPML4 = NULL;
    PVOID pVirtualAdddressOfPML4 = NULL;
    PHYSICAL_ADDRESS PhysicalAddress = {0};

    pOperatingSystemThunkState->PAEPageTables32.uiLastPageIndexAllocated++;

    pPhysicalAdddressOfPML4 = (PVOID)((unsigned char *)pOperatingSystemThunkState->PAEPageTables32.OSAllocatedMemoryBlock.Aligned4kPhysicalAddress + (pOperatingSystemThunkState->PAEPageTables32.uiLastPageIndexAllocated<<12));
    pVirtualAdddressOfPML4  = (PVOID)((unsigned char *)pOperatingSystemThunkState->PAEPageTables32.OSAllocatedMemoryBlock.pVirtualMappingOf4kPhysicalAddress + (pOperatingSystemThunkState->PAEPageTables32.uiLastPageIndexAllocated<<12));

    pPageTablePML4Entry     = (PPAGETABLE_PML4_ENTRY64)pVirtualAdddressOfPML4;

    PHYSICAL_ADDRESS_TO_4K_BOUNDARY_PAE64_STYLE(pPageTablePML4Entry->wPhysicalAddress, pPageTablePML4Entry->dwPhysicalAddressAndAvailableBits, (unsigned int)pOperatingSystemThunkState->PageTables64.pPhysicalAddressOfPDP);
    pPageTablePML4Entry->bPagingAttributes = PAGING64_FLAG_IS_PRESENT | PAGING64_FLAG_WRITABLE;

    pOperatingSystemThunkState->PageTables64.pPageTablePML4Entry    = pPageTablePML4Entry;
    pOperatingSystemThunkState->PageTables64.pPhysicalAddressOfPML4 = pPhysicalAdddressOfPML4;

    return NtStatus;
}




/**********************************************************************
 * 
 *  Paging64_MapVirtualToPhysical
 *
 *    This API will map a virtual address to a physical address
 *    in 64 bit
 *
 **********************************************************************/
NTSTATUS Paging64_MapVirtualToPhysical(POPERATING_SYSTEM_THUNK_DATA pOperatingSystemThunkState, unsigned _int64  uiVirtualAddress64, unsigned _int64  uiPhysicalAddress64)
{   
    NTSTATUS NtStatus = STATUS_NOT_IMPLEMENTED;
    /*
     * Not implemented, you can use the 32 bit PAE to do this unless you want 64 bit Virtual Addresses which
     * was not important here.
     */            
    return NtStatus;
}


