;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
;   AUTHOR: Toby Opferman
;   DATE:   September 29, 2005 
;
;   DESCRIPTION:
;           This will Opposite the Pixels (Makes the screen look a little blury at this high resolution) 
;
;   OPPOSITE.ASM
;
;   Copyright (C) 2005 All Rights Reserved
;=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-


;

; Put the screen into 1280x1024x32bit Color and if this is the maximum resolution
;  and the memory is in the same place as my video card, this will flip the screen.
;
;  My video card has 0d8000000h as the extended linear video memory.
; NVIDIA GeForce2 MX


LOADK64 SEGMENT 
START:
   ORG 0             ; If you want to use the stack just refresh RSP so that the TOP half is correct.  ESP is fine, but
                     ; we can't trust the top 32 bits to be clear.
   MOV RDI, 0d8000000h
   MOV RCX, 327680*2    
OPPOSITE_THE_SCREEN:
   MOV RAX, QWORD PTR [RDI]
   ROL RAX, 32
   MOV QWORD PTR [RDI], RAX
   ADD RDI, 8
   DEC RCX
   JNZ SHORT OPPOSITE_THE_SCREEN
   RETF              ; RETF will return to the Operating System in this model.
LOADK64 ENDS


END START
