/*
   AUTHOR: Toby Opferman
   DATE:   June 18, 2000

   DESCRIPTION: 
           Binary File Header Remover

   RMHDR.C  

   Copyright (C) 2000
*/

/* Header Files */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

/* Prototypes */
int DoesFileExist(char *);
void DispatchMsg(int);
void RemoveHdr(char *, char *, int);

 /* Main Module */
 int __cdecl main(int argc, char **argv)
{
   /* Check For File Name */
   if(argc != 4)
   {
     DispatchMsg(0);
     return 0;
   }

   /* Check If File Doesn't Already */
   if(!DoesFileExist(argv[1]))
   {
     DispatchMsg(1);
     return 0;
   }

   /* Check If File Already Exists */
   if(DoesFileExist(argv[2]))
   {
     DispatchMsg(3);
     return 0;
   }

   /* Remove Header */
   RemoveHdr(argv[1], argv[2], atoi(argv[3]));

   return 0;
}

 /* Display System Message */
 void DispatchMsg(int Msg)
{
   switch(Msg)
   {
      case 0:
          printf("Remove Binary Header\n");
          printf(" Usage:\n");
          printf("   NEWSRC <Input FileName> <Output FileName> <Header Size>\n");
          break;

      case 1:
          printf("Input File doesn't exist or cannot access\n");
          break;

      case 2:
          printf("Cannot Create Output File\n");
          break;

      case 3:
          printf("Output File Already Exists, Will Not Overwrite.\n");
          break;

      case 4:
          printf("Complete\n");
   }
}

 /* Check If File Exists */
 int DoesFileExist(char *FileName)
{
   FILE *File;

   /* Open File For Read */
   if(File = fopen(FileName, "rb"))
   {
       fclose(File);
       return 1;
   }

   return 0;
}

 /* Remove Header */
 void RemoveHdr(char *InFileName, char *OutFileName, int Size)
{
   FILE *InFile, *OutFile;
   int BlockSize;
   char Buffer[256];
  
   /* Open File */
   if(!(InFile = fopen(InFileName, "rb")))
   {
      DispatchMsg(1);
      return;
   }

   /* Open File */
   if(!(OutFile = fopen(OutFileName, "wb")))
   {
      fclose(InFile);
      DispatchMsg(2);
      return;
   }

   /* Seek To End Of Header */
   fseek(InFile, Size, SEEK_SET);

   fflush(InFile);

   printf("Stripping %i Bytes\n", Size);

   /* Write New Output File */
   do {

     BlockSize = fread(Buffer, 1, 256, InFile);
     
     if(BlockSize)
       fwrite(Buffer, 1, BlockSize, OutFile);


   } while(BlockSize);

   /* Close Files */
   fclose(InFile);
   fclose(OutFile);

   DispatchMsg(4);
}

