/*
 * Progress UI Header File
 *
 *
 */

#ifndef __PROGRESSUI_H__
#define __PROGRESSUI_H__

#define IDC_PROGRESS_STATUS 300
#define IDC_PROGRESS_BAR    301

typedef PVOID HPROGRESS;

typedef void (* PFNPROGRESSBARWORK)(HPROGRESS hProgress, PVOID pContext);
typedef void (* PFNCANCELCALLBACK)(HPROGRESS hProgress, PVOID pContext);

#define FLAG_WORKER_CONTEXT_CURRENT_THREAD      1

HPROGRESS Progress_CreateDisplay(HWND hWnd, HINSTANCE hInstance, UINT uiResource, PVOID pContext, PFNCANCELCALLBACK pfnCancelCallback);
void Progress_MessageLoop(HPROGRESS hProgress);
void Progress_Advance(HPROGRESS hProgress, UINT uPercentage, char *pszStatus);
void Progress_CompleteAndClose(HPROGRESS hProgress);
void Progress_CompleteAndCloseQuickWithReturn(HPROGRESS hProgress, PVOID pReturnValue);

PVOID Progress_QuickProgressBar(HWND hWnd, HINSTANCE hInstance, UINT uiResource, PVOID pContext, PFNCANCELCALLBACK pfnCancelCallback, PFNPROGRESSBARWORK pfnProgressBarWork, DWORD dwFlags);

#endif

