; example2.nsi
;
; This script is based on example1.nsi, but it remember the directory, 
; has uninstall support and (optionally) installs start menu shortcuts.
;
; It will install example2.nsi into a directory that the user selects,

;--------------------------------

; The name of the installer
Name "Amelia's Big Adventure"

; The file to write
OutFile "amelia_setup.exe"

; The default installation directory
InstallDir $PROGRAMFILES\Opferman\Amelia

; Registry key to check for directory (so if you install again, it will 
; overwrite the old one automatically)
; InstallDirRegKey HKLM "Software\NSIS_Example2" "Install_Dir"

;--------------------------------

; Pages

Page components
Page directory
Page instfiles

UninstPage uninstConfirm
UninstPage instfiles

;--------------------------------

; The stuff to install
Section "Amelias Big Adventure"

  SectionIn RO
  
  ; Set output path to the installation directory.
  SetOutPath $INSTDIR
  
  ; Put file there
  File "..\amelia_game\*.*" 
;  File "..\amelia_game\ameliafw.gif"
;  File "..\amelia_game\ameliafw2.gif"
;  File "..\amelia_game\ameliafw3.gif"
;  File "..\amelia_game\ameliafw4.gif"
;  File "..\amelia_game\amelialeft1.gif"
;  File "..\amelia_game\amelialeft2.gif"
;  File "..\amelia_game\amelialeft3.gif"
;  File "..\amelia_game\amelialeft4.gif"
;  File "..\amelia_game\ameliaright1.gif"
;  File "..\amelia_game\ameliaright2.gif"
;  File "..\amelia_game\ameliaright3.gif"
;  File "..\amelia_game\ameliaright4.gif"
;  File "..\amelia_game\AmeliaStand.gif"
;  File "..\amelia_game\ameliawalk.gif"
;  File "..\amelia_game\ameliawalk2.gif"
;  File "..\amelia_game\ameliawalk3.gif"
;  File "..\amelia_game\ameliawalk4.gif"
;  File "..\amelia_game\birdfly1.gif"
;  File "..\amelia_game\birdfly2.gif"
;  File "..\amelia_game\birdfly3.gif"
;  File "..\amelia_game\birdfly4.gif"
;  File "..\amelia_game\levelonesong.wav"
;  File "..\amelia_game\redbird1.gif"
;  File "..\amelia_game\redbird2.gif"
;  File "..\amelia_game\redbird3.gif"
;  File "..\amelia_game\redbird4.gif"
;  File "..\amelia_game\s1.wav"
;  File "..\amelia_game\s10.wav"
;  File "..\amelia_game\s2.wav"
;  File "..\amelia_game\s3.wav"
;  File "..\amelia_game\s4.wav"
;  File "..\amelia_game\s5.wav"
;  File "..\amelia_game\s6.wav"
;  File "..\amelia_game\s7.wav"
;  File "..\amelia_game\s8.wav"
;  File "..\amelia_game\s9.wav"
;  File "..\amelia_game\tiles1.gif"
;  File "..\amelia_game\title.gif"
;  File "..\amelia_game\title.wav"
;  File "..\amelia_game\welcome.wav"



   
  ; Write the installation path into the registry
  WriteRegStr HKLM SOFTWARE\opferman\Amelia "Install_Dir" "$INSTDIR"
  
  ; Write the uninstall keys for Windows
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Amelia Big Adventure" "DisplayName" "Amelias Big Adventure"
  WriteRegStr HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Amelia Big Adventure" "UninstallString" '"$INSTDIR\uninstall.exe"'
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Amelia Big Adventure" "NoModify" 1
  WriteRegDWORD HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Amelia Big Adventure" "NoRepair" 1
  WriteUninstaller "uninstall.exe"
  
;SectionEnd

; Optional section (can be disabled by the user)
;Section "Start Menu Shortcuts"

  CreateDirectory "$SMPROGRAMS\Opferman"
  CreateDirectory "$SMPROGRAMS\Opferman\Amelia"
  CreateShortCut "$SMPROGRAMS\Opferman\Amelia\Uninstall.lnk" "$INSTDIR\uninstall.exe" "" "$INSTDIR\uninstall.exe" 0
  CreateShortCut "$SMPROGRAMS\Opferman\Amelia\Amelias Big Adventure.lnk" "$INSTDIR\amelia.exe" "" "$INSTDIR\amelia.exe" 0
  
SectionEnd

;--------------------------------

; Uninstaller

Section "Uninstall"
  
  ; Remove registry keys
  DeleteRegKey HKLM "Software\Microsoft\Windows\CurrentVersion\Uninstall\Amelia Big Adventure"
  DeleteRegKey HKLM SOFTWARE\opferman\Amelia

  ; Remove files and uninstaller
  Delete $INSTDIR\amelia.exe
  Delete $INSTDIR\amelia.dll
  Delete $INSTDIR\uninstall.exe

  ; Remove shortcuts, if any
  Delete "$SMPROGRAMS\Opferman\Amelia\*.*"

  ; Remove directories used
  RMDir "$SMPROGRAMS\Opferman\Amelia"
  RMDir "$INSTDIR"

SectionEnd
