/*
 * Level Editor Header File
 *
 *
 */
#ifndef __GAME_H__
#define __GAME_H__

#include <gdi.h>


typedef PVOID HLEVELEDITOR;

#define GAME_CLASS_NAME "LevelEditor"
#define GAME_TITLE      "Amelia's Big Adventure - Level Editor"

#define GAME_WIDTH  800
#define GAME_HEIGHT 600


#define GAME_WIDTH_BOTTOM   800
#define GAME_HEIGHT_BOTTOM  (48*4)

#define GAME_WINDOW_WIDTH  (GAME_WIDTH) + 10
#define GAME_WINDOW_HEIGHT (GAME_HEIGHT + GAME_HEIGHT_BOTTOM)  + 50

HLEVELEDITOR LevelEditor_Init(HWND hWnd, HINSTANCE hInstance);
void LevelEditor_Close(HLEVELEDITOR hLevelEditor);
void LevelEditor_HandleKeyRelease(HLEVELEDITOR hLevelEditor, UINT vKey);
void LevelEditor_HandleKeyPress(HLEVELEDITOR hLevelEditor, UINT vKey);
void LevelEditor_HandleMenuCommands(HLEVELEDITOR hLevelEditor, USHORT Command, LPARAM lParam);
HDC LevelEditor_GetLevelDc(HLEVELEDITOR hLevelEditor);
void LevelEditor_ReleaseLevelDc(HLEVELEDITOR hLevelEditor, HDC hLevelDC);
BOOL LevelEditor_MessageLoop(HLEVELEDITOR hLevelEditor);
HGDI LevelEditor_GenericLoadGif(PCHAR pszImageName, UINT uiImageNumber);


#endif

