/*
 * Game Header File
 *
 *
 */
#ifndef __GAMEINTERNAL_H__
#define __GAMEINTERNAL_H__

#include <maploader.h>

struct _GAME_INTERNAL;
typedef struct _GAME_INTERNAL GAME_INTERNAL, *PGAME_INTERNAL;


typedef BOOL (*PFNWORKERFUNCTION)(PGAME_INTERNAL pGameInternal);

typedef struct _PROGRESS_DATA
{
	UINT ProgressPercentage;
	char *pszProgressMessage;
	char *pszErrorMessage;
	PFNWORKERFUNCTION pfnWorkerFunction;

} PROGRESS_DATA, *PPROGRESS_DATA;

extern PPROGRESS_DATA g_ProgressMap[];

/*
 * Prototypes
 */
BOOL GameTitle_LoadTitleGif(PGAME_INTERNAL pGameInternal);
BOOL GameTitle_LoadTitleAudio(PGAME_INTERNAL pGameInternal);
BOOL GameTitle_CreateGameScreen(PGAME_INTERNAL pGameInternal);

BOOL GameLevel1_LoadGraphics(PGAME_INTERNAL pGameInternal);
BOOL GameLevel1_LoadAudio(PGAME_INTERNAL pGameInternal);
BOOL GameLevel1_InitializeLevelEngine(PGAME_INTERNAL pGameInternal);
BOOL GameLevel1_BuidTiles(PGAME_INTERNAL pGameInternal);

typedef enum _GAME_STATE
{
	GameTitle,
	LevelOne,
	LevelTwo,
	LevelThree,
	LevelFour,
	LevelFive

} GAME_STATE, *PGAME_STATE;

typedef struct _TITLE_DATA
{
	BOOL TitleFaded;
	HGDI hTitleScreen;
	HTAUDIO hTAudioBackground;
	HTAUDIO hTAudioAmeliaWelcome;

} TITLE_DATA, *PTITLE_DATA;

typedef struct _AI_ENGINE
{
	BOOL EngineIsActive;
	int iDirectionX;
	int iDirectionY;
	BOOL bDirectionChange;
	UINT DirectionCounter;
	BOOL LastMoveBlocked;
	UINT LastMoveBlockedCounter;

} AI_ENGINE, *PAI_ENGINE;

#define NUMBER_OF_ANIMAL_EFFECTS  2
#define NUMBER_OF_L1_TILES_X 16
#define NUMBER_OF_L1_TILES_Y 46
#define NUMBER_OF_L1_TILES (16*46)
#define NUMBER_OF_CATS     20
#define NUMBER_OF_DOGS     30
#define NUMBER_OF_ALPHABET 26

typedef struct _LEVEL_ONE_DATA
{
	HLEVEL hLevel;

    SPRITE_DATA Amelia;
	SPRITE_DATA Alphabet[NUMBER_OF_ALPHABET];
	SPRITE_DATA Cat;
	SPRITE_DATA Dog;
	AI_ENGINE CatAi[NUMBER_OF_CATS];
	AI_ENGINE DogAi[NUMBER_OF_DOGS];
	
	SPRITE_DATA Animal[NUMBER_OF_ANIMAL_EFFECTS];
	UINT AnimalIndex;
	UINT NumberOfAnimals;
	UINT TickOfLastAnimal;
	BOOL AnimalInProgress;

	UINT CatsCaptured;
	UINT DogsCaptured;
	UINT AlphabetCaptured;


	int CurrentX;
	int CurrentY;
	int CurrentXInc;
	int CurrentYInc;

	HGDI hTileGraphic;
	TILE_DESCRIPTION TileDescription[NUMBER_OF_L1_TILES];
	int DirectionX;
    int DirectionY;
	BOOL AutoPilot;
	BOOL bDirectionChange;
	HTAUDIO hTAudioBGEffects;
	HTAUDIO hTAudioBackground;
	HTAUDIO hTAudioEffects;
	UINT   TickOfLastEffect;
	MAP_INFO LevelOneMap;
	DWORD  GameScore;
	DWORD  TimeLimit;
	DWORD  TimeFreeze;
	DWORD  LastUpdateTime;


} LEVEL_ONE_DATA, *PLEVEL_ONE_DATA;

typedef struct _GAME_SCREEN
{
	HGDI hGameScreen;	

} GAME_SCREEN, *PGAME_SCREEN;


typedef struct _GAME_OPTIONS
{
	BOOL EnableMusic;
	BOOL EnableSoundEffects;	

} GAME_OPTIONS, *PGAME_OPTIONS;


typedef struct _FUNCTION_THUNKS
{
	//PFNKEYPRESS   pfnKeyPress;
	//PFNKEYRELEASE pfnKeyRelease;

	UINT Example;
	UINT Testing;

} FUNCTION_THUNKS, *PFUNCTION_THUNKS;


typedef struct _GAME_INTERNAL
{
	HWND        hWnd;
	HINSTANCE   hInstance;

	GAME_OPTIONS GameOptions;
	GAME_SCREEN  GameScreen;

    GAME_STATE   GameState;

	TITLE_DATA     TitleData;
	LEVEL_ONE_DATA LevelOneData;

//	FUNCTION_THUNKS FunctionThunks;

} GAME_INTERNAL, *PGAME_INTERNAL;

#endif

