#include <windows.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <taudio.h>
#include <gdi.h>
#include <gif.h>
#include <leveleng.h>
#include <progress.h>
#include <maploader.h>
#include "game.h"
#include "gameres.h"
#include "gameinternal.h"
#include "levelone.h"

#if 0
#define TILE_WORLD_Y 65
#define TILE_WORLD_X 34

extern DWORD g_LevelOneMap[];
#endif

#define AMELIA_SPEED   3
#define CAT_MIN_SPEED  1
#define CAT_RUN_SPEED  1

#define DOG_MIN_SPEED  1
#define DOG_RUN_SPEED  1

#define CAT_POINTS         100
#define DOG_POINTS         50
#define CHOCOLATE_POINTS   25
#define JUICE_POINTS       15
#define ALPHABET_POINTS(x) (((x+1))*10)
#define TICKS_PER_SECOND   (1000/1) /* Assume 1ms Tick Rate */

#define TIME_LIMIT_MINUTES  10

#define AMELIA_SPRITE 0
char *g_pszAmeliaSprites[] =
{ 
	"AmeliaStand.gif",
	"ameliawalk.gif",
	"ameliawalk2.gif",
	"ameliawalk3.gif",
	"ameliawalk4.gif",
	NULL,
	"ameliafw.gif",
	"ameliafw2.gif",
	"ameliafw3.gif",
	"ameliafw4.gif",
	NULL,
	"amelialeft1.gif",
	"amelialeft2.gif",
	"amelialeft3.gif",
	"amelialeft4.gif",
	NULL,
	"ameliaright1.gif",
	"ameliaright2.gif",
	"ameliaright3.gif",
	"ameliaright4.gif",
	NULL
};

char *g_pszBirdFlySprites[] =
{ 
	NULL,
	NULL,
	NULL,
	"birdfly1.gif",
	"birdfly2.gif",
	NULL,
	"birdfly3.gif",
	"birdfly4.gif",
	NULL
};

char *g_pszRedBirdFlySprites[] =
{ 
	NULL,
	NULL,
	NULL,
	"redbird1.gif",
	"redbird2.gif",
	NULL,
	"redbird3.gif",
	"redbird4.gif",
	NULL
};

#define CAT_SPRITE 1
char *g_pszCatSprites[] =
{ 
	"catStand.gif",
	"catwalk.gif",
	"catwalk2.gif",
	"catwalk3.gif",
	"catwalk4.gif",
	NULL,
	"catfw.gif",
	"catfw2.gif",
	"catfw3.gif",
	"catfw4.gif",
	NULL,
	"catleft1.gif",
	"catleft2.gif",
	"catleft3.gif",
	"catleft4.gif",
	NULL,
	"catright1.gif",
	"catright2.gif",
	"catright3.gif",
	"catright4.gif",
	NULL
};

#define DOG_SPRITE (CAT_SPRITE + NUMBER_OF_CATS + 1)
char *g_pszDogSprites[] =
{ 
	"dogStand.gif",
	"dogwalk.gif",
	"dogwalk2.gif",
	"dogwalk3.gif",
	"dogwalk4.gif",
	NULL,
	"dogfw.gif",
	"dogfw2.gif",
	"dogfw3.gif",
	"dogfw4.gif",
	NULL,
	"dogleft1.gif",
	"dogleft2.gif",
	"dogleft3.gif",
	"dogleft4.gif",
	NULL,
	"dogright1.gif",
	"dogright2.gif",
	"dogright3.gif",
	"dogright4.gif",
	NULL
};

#define ALPHABET_SPRITE (DOG_SPRITE + NUMBER_OF_DOGS + 1)
#define NUMBER_OF_EFFECTS 6

#define CAT_EFFECT_START   0
#define CAT_NUMBER_EFFECTS 3
#define DOG_EFFECT_START   3
#define DOG_NUMBER_EFFECTS 2
#define ALPHABET_EFFECT_START   5
#define ALPHABET_NUMBER_EFFECTS 1

char *g_pszSoundEffects[] =
{ 
	"catsgood.wav",
	"meow.wav",
	"meow2.wav",
	"dogbark.wav",
	"dogyelp.wav",
	"alphabet.wav"
};


#define TICK_INTERVALS (15000)  /* 1 Tick is Approx. 15ms by default, so for 15 seconds 15000ms/10 = 15000 */
#define TICK_ANIMAL_INTERVALS (20000)



/*
 * Internal Prototypes
 */
void GameLevel1_ToggleMusic(PGAME_INTERNAL pGameInternal);
void GameLevel1_ToggleSound(PGAME_INTERNAL pGameInternal);
void GameLevel1_EffectsHandler(HLEVEL hLevel, char *pScreenBuffer, PVOID pContext);
BOOL GameLevel1_DrawSprite(HGDI hImageGDI, DWORD *pScreen, UINT ScreenWidth, UINT ScreenHeight, UINT ImageX, UINT ImageY);
void GameLevel1_Debug(char *pszFormatString, ...);
void GameLevel1_CatAI(PGAME_INTERNAL pGameInternal, UINT Index);
void GameLevel1_GetRandomTileCoordinates(PGAME_INTERNAL pGameInternal, UINT *pTileX, UINT *pTileY);
void GameLevel1_SpriteCollision(HLEVEL hLevel, PVOID pContext, DWORD dwSpriteId);
void GameLevel1_SpriteCatCollision(PGAME_INTERNAL pGameInternal, DWORD dwSpriteId);
void GameLevel1_SpriteDogCollision(PGAME_INTERNAL pGameInternal, DWORD dwSpriteId);
void GameLevel1_DogAI(PGAME_INTERNAL pGameInternal, UINT Index);
void GameLevel1_InitAlphabetSprites(PGAME_INTERNAL pGameInternal);

 /***********************************************************************
  * GameLevel1_LoadGraphics
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL GameLevel1_LoadGraphics(PGAME_INTERNAL pGameInternal)
{
	BOOL Status = FALSE;
	UINT Index = 0;

    if(MapLoader_LoadMap("LevelOne.MAP", &pGameInternal->LevelOneData.LevelOneMap))
	{
		Status = Game_GenericLoadSprite(&pGameInternal->LevelOneData.Amelia, g_pszAmeliaSprites, 17);

		if(Status)
		{
			Status = Game_GenericLoadSprite(&pGameInternal->LevelOneData.Animal[0], g_pszBirdFlySprites, 5);
			pGameInternal->LevelOneData.Animal[0].AnimationPauses = 3;
			pGameInternal->LevelOneData.NumberOfAnimals           = 1;

			if(Status)
			{
				Status = Game_GenericLoadSprite(&pGameInternal->LevelOneData.Animal[1], g_pszRedBirdFlySprites, 5);
    			pGameInternal->LevelOneData.Animal[1].AnimationPauses = 3;
	    		pGameInternal->LevelOneData.NumberOfAnimals           = 2;

				if(Status)
				{
					Status = Game_GenericLoadSprite(&pGameInternal->LevelOneData.Cat, g_pszCatSprites, 17);

					for(Index = 0; Index < NUMBER_OF_CATS; Index++)
					{
						pGameInternal->LevelOneData.CatAi[Index].EngineIsActive = TRUE;
					}

					Status |= Game_GenericLoadSprite(&pGameInternal->LevelOneData.Dog, g_pszDogSprites, 17);

					for(Index = 0; Index < NUMBER_OF_DOGS; Index++)
					{
						pGameInternal->LevelOneData.DogAi[Index].EngineIsActive = TRUE;
					}

					GameLevel1_InitAlphabetSprites(pGameInternal);

					if(Status)
					{
						pGameInternal->LevelOneData.hTileGraphic = Game_GenericLoadGif("tiles1.gif", 0);

						if(pGameInternal->LevelOneData.hTileGraphic == NULL)
						{
							Status = FALSE;
						}
					}
				}
			}
		}
	}

	return Status;
}

 /***********************************************************************
  * GameLevel1_BuidTiles
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL GameLevel1_BuidTiles(PGAME_INTERNAL pGameInternal)
{
	BOOL Status = FALSE;
	UINT IndexX;
	UINT IndexY;
	UINT Index;
	char *pBuffer;

	if(pGameInternal->LevelOneData.hTileGraphic)
	{
		pBuffer = GDI_BeginPaint(pGameInternal->LevelOneData.hTileGraphic);
		Status = TRUE;

		for(Index = 0, IndexY = 0; IndexY < NUMBER_OF_L1_TILES_Y; IndexY++)
		{
			for(IndexX = 0; IndexX < NUMBER_OF_L1_TILES_X; IndexX++, Index++)
			{
				pGameInternal->LevelOneData.TileDescription[Index].TileIndex   = Index;
				pGameInternal->LevelOneData.TileDescription[Index].hTileGdi    = pGameInternal->LevelOneData.hTileGraphic;
				pGameInternal->LevelOneData.TileDescription[Index].pTileBuffer = pBuffer;
				pGameInternal->LevelOneData.TileDescription[Index].TileStartOffsetX = (3*IndexX) + 2 + (IndexX*48);
				pGameInternal->LevelOneData.TileDescription[Index].TileStartOffsetY = (3*IndexY) + 2 + (IndexY*48);
				pGameInternal->LevelOneData.TileDescription[Index].TileStride  = 816; // Change this later to not be hard coded here
			}
		}
	}

	return Status;
}




 /***********************************************************************
  * GameLevel1_LoadAudio
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL GameLevel1_LoadAudio(PGAME_INTERNAL pGameInternal)
{
	BOOL Status = FALSE;
    char *pszBackgroundMusic = "levelonesong.wav";
	char *pszRandomeBGEffects1[]                 = { "s1.wav", 
		                                             "s2.wav",  
													 "s3.wav",  
													 "s4.wav", 
													 "s5.wav", 
													 "s6.wav", 
													 "s7.wav", 
													 "s8.wav", 
													 "s9.wav", 
													 "s10.wav" 
	};
    

    pGameInternal->LevelOneData.hTAudioBackground = TAudio_Init(&pszBackgroundMusic, 1, FLAG_LOOP_SOUND);

	if(pGameInternal->LevelOneData.hTAudioBackground)
	{
    	 pGameInternal->LevelOneData.hTAudioBGEffects = TAudio_Init(pszRandomeBGEffects1, 10, 0);

		 if(pGameInternal->LevelOneData.hTAudioBGEffects)
		 {
			 pGameInternal->LevelOneData.hTAudioEffects = TAudio_Init(g_pszSoundEffects, NUMBER_OF_EFFECTS, 0);

			 if(pGameInternal->LevelOneData.hTAudioEffects)
			 {
				Status = TRUE;
			 }
		 }
	}

	return Status;
}

/***********************************************************************
 * GameLevel1_ToggleMusic
 *  
 *    
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void GameLevel1_ToggleMusic(PGAME_INTERNAL pGameInternal)
{
	
	if(pGameInternal->GameOptions.EnableMusic)
	{
		CheckMenuItem(GetMenu(pGameInternal->hWnd), IDM_MUSIC, MF_UNCHECKED);
		TAudio_PauseSound(pGameInternal->LevelOneData.hTAudioBackground);
		pGameInternal->GameOptions.EnableMusic = FALSE;
	}
	else
	{
		CheckMenuItem(GetMenu(pGameInternal->hWnd), IDM_MUSIC, MF_CHECKED);
		TAudio_PlaySound(pGameInternal->LevelOneData.hTAudioBackground, 0);
		pGameInternal->GameOptions.EnableMusic = TRUE;
	}
}



/***********************************************************************
 * GameLevel1_ToggleSound
 *  
 *    
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void GameLevel1_ToggleSound(PGAME_INTERNAL pGameInternal)
{
	if(pGameInternal->GameOptions.EnableSoundEffects)
	{
		CheckMenuItem(GetMenu(pGameInternal->hWnd), IDM_SOUND, MF_UNCHECKED);
		pGameInternal->GameOptions.EnableSoundEffects = FALSE;
	}
	else
	{
		CheckMenuItem(GetMenu(pGameInternal->hWnd), IDM_SOUND, MF_CHECKED);
		pGameInternal->GameOptions.EnableSoundEffects = TRUE;
	}
}


/***********************************************************************
 * GameLevel1_InitAlphabetSprites
 *  
 *    
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void GameLevel1_InitAlphabetSprites(PGAME_INTERNAL pGameInternal)
{
	UINT Index = 0;
	UINT SizeX;
	UINT SizeY;
	UINT LetterSizeX;
	UINT CurrentX;
	UINT IndexY;
	UINT IndexX;
	HGDI hAlphabetGdi;
	DWORD *pAlphabetBuffer;
	DWORD *pLetter;
	DWORD dwIgnoreColor;
	BOOL  FoundEndOfLetter;
	BOOL  FoundStartOfLetter;

    hAlphabetGdi = Game_GenericLoadGif("alphabet.gif", 0);
	GDI_GetSize(hAlphabetGdi, &SizeX, &SizeY);

	pAlphabetBuffer = (DWORD *)GDI_BeginPaint(hAlphabetGdi);
	dwIgnoreColor = *pAlphabetBuffer;

	CurrentX = 0;

	for(Index = 0; Index < NUMBER_OF_ALPHABET; Index++)
	{
		
		FoundStartOfLetter = FALSE;

		IndexX = 0;
		LetterSizeX = 0;
		while(FoundStartOfLetter == FALSE)
		{
			
			for(IndexY = 0; IndexY < SizeY && FoundStartOfLetter == FALSE; IndexY++)
			{
				if(pAlphabetBuffer[CurrentX + IndexX + (IndexY*SizeX)] != dwIgnoreColor)
				{
					FoundStartOfLetter = TRUE;
				}
			}

			if(FoundStartOfLetter == FALSE)
			{
				IndexX++;
				LetterSizeX++;
			}
		}

		FoundEndOfLetter = FALSE;

		while(FoundEndOfLetter == FALSE)
		{
			FoundEndOfLetter = TRUE;
			
			for(IndexY = 0; IndexY < SizeY && FoundEndOfLetter; IndexY++)
			{
				if(pAlphabetBuffer[CurrentX + IndexX + (IndexY*SizeX)] != dwIgnoreColor)
				{
					FoundEndOfLetter = FALSE;
				}
			}

			if(FoundEndOfLetter == FALSE)
			{
				IndexX++;
				LetterSizeX++;
			}
		}
		
		pGameInternal->LevelOneData.Alphabet[Index].hStanding = GDI_Init(NULL, LetterSizeX, SizeY);
		pLetter = (DWORD *)GDI_BeginPaint(pGameInternal->LevelOneData.Alphabet[Index].hStanding);
		pGameInternal->LevelOneData.Alphabet[Index].NumberOfAnimations = 1;

		for(IndexX = 0; IndexX < LetterSizeX; IndexX++)
		{
			for(IndexY = 0; IndexY < SizeY; IndexY++)
			{
				pLetter[IndexX + (IndexY*LetterSizeX)] = pAlphabetBuffer[CurrentX + IndexX + (IndexY*SizeX)];
			}
		}

		GDI_EndPaint(pGameInternal->LevelOneData.Alphabet[Index].hStanding);

		CurrentX += LetterSizeX;

		pGameInternal->LevelOneData.Alphabet[Index].SpriteIsStanding = TRUE;
	}

	GDI_EndPaint(hAlphabetGdi);
	GDI_UnInit(hAlphabetGdi);
}


/***********************************************************************
 * GameLevel1_HandleMenuCommands
 *  
 *    
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void GameLevel1_HandleMenuCommands(PGAME_INTERNAL pGameInternal, USHORT Command, LPARAM lParam)
{
	switch(Command)
	{
		case IDM_MUSIC:
			 GameLevel1_ToggleMusic(pGameInternal);
			 break;
		case IDM_SOUND:
			 GameLevel1_ToggleSound(pGameInternal);
			 break;

		case IDM_ABOUT:
			 break;

		case IDM_NEW_GAME:
			 break;

		case IDM_EXIT:
			 SendMessage(pGameInternal->hWnd, WM_CLOSE, 0, 0);
			 break;
	}
}

 /***********************************************************************
  * GameLevel1_InitializeLevelEngine
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL GameLevel1_InitializeLevelEngine(PGAME_INTERNAL pGameInternal)
{
	BOOL Status = FALSE;
	LEVEL_PARAMS LevelParams;

	LevelParams.pLevelContext  = pGameInternal;

	LevelParams.TileInfo.Width  = 48;
    LevelParams.TileInfo.Height = 48;
	LevelParams.TileInfo.StartTileX = 6;
    LevelParams.TileInfo.StartTileY = 5;
    LevelParams.TileInfo.NumberOfTiles = NUMBER_OF_L1_TILES;
	LevelParams.TileInfo.pTileDescription = &pGameInternal->LevelOneData.TileDescription[0];

    LevelParams.ScreenInfo.Width  = GAME_WIDTH;
	LevelParams.ScreenInfo.Height = GAME_HEIGHT;
	LevelParams.ScreenInfo.hScreenGdi = pGameInternal->GameScreen.hGameScreen;

    LevelParams.WorldMap.Width  = pGameInternal->LevelOneData.LevelOneMap.MapResolutionX;
	LevelParams.WorldMap.Height = pGameInternal->LevelOneData.LevelOneMap.MapResolutionY;
	LevelParams.WorldMap.pTileMap = pGameInternal->LevelOneData.LevelOneMap.MapData;
    
	LevelParams.SpriteData = pGameInternal->LevelOneData.Amelia;

	LevelParams.pfnEffectsCallback = GameLevel1_EffectsHandler;
	LevelParams.pfnSpriteCollision = GameLevel1_SpriteCollision;

    pGameInternal->LevelOneData.hLevel = Level_Create(&LevelParams);

    if(pGameInternal->LevelOneData.hLevel)
	{
		UINT StartX, StartY;
		UINT Index;

		for(Index = 0; Index < NUMBER_OF_CATS; Index++)
		{
			GameLevel1_GetRandomTileCoordinates(pGameInternal, &StartX, &StartY);
			Level_AddSprite(pGameInternal->LevelOneData.hLevel, CAT_SPRITE + Index, &pGameInternal->LevelOneData.Cat, StartX, StartY);
		}

		for(Index = 0; Index < NUMBER_OF_DOGS; Index++)
		{
			GameLevel1_GetRandomTileCoordinates(pGameInternal, &StartX, &StartY);
			Level_AddSprite(pGameInternal->LevelOneData.hLevel, DOG_SPRITE + Index, &pGameInternal->LevelOneData.Dog, StartX, StartY);
		}

		for(Index = 0; Index < NUMBER_OF_ALPHABET; Index++)
		{
			GameLevel1_GetRandomTileCoordinates(pGameInternal, &StartX, &StartY);
			Level_AddSprite(pGameInternal->LevelOneData.hLevel, ALPHABET_SPRITE + Index, &pGameInternal->LevelOneData.Alphabet[Index], StartX, StartY);
		}

		Status = TRUE;
	}

	pGameInternal->LevelOneData.TimeLimit      = TIME_LIMIT_MINUTES*60;
	pGameInternal->LevelOneData.LastUpdateTime = GetTickCount();

	return Status;
}


 /***********************************************************************
  * GameLevel1_EffectsHandler
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_EffectsHandler(HLEVEL hLevel, char *pScreenBuffer, PVOID pContext)
{
	UINT TickCount = GetTickCount();
	BOOL DrawAnimation = FALSE;
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)pContext;
	UINT Width, Height;
	MOVEMENT_DIRECTION MovementDirection;
	PSPRITE_DATA pSpriteData;
	BOOL bFoundSprites = FALSE;

	if(pGameInternal->LevelOneData.AnimalInProgress)
	{
		DrawAnimation = TRUE;
	}
	else
	{
		if(TickCount > pGameInternal->LevelOneData.TickOfLastAnimal + TICK_ANIMAL_INTERVALS)
		{
			DrawAnimation = TRUE;
			pGameInternal->LevelOneData.AnimalInProgress = TRUE;
			MovementDirection = rand() % 4;

			switch(MovementDirection)
			{
				case MoveDown: /* Top down      */
					 pGameInternal->LevelOneData.CurrentX = rand() % (GAME_WIDTH - 20); 
					 pGameInternal->LevelOneData.CurrentY = 0; 
					 pGameInternal->LevelOneData.CurrentXInc = (rand() % 3) - 1;
					 pGameInternal->LevelOneData.CurrentYInc = (rand() % 3) + 1;
					 break;

				case MoveUp: /* Bottom Up     */
					 pGameInternal->LevelOneData.CurrentX = rand() % (GAME_WIDTH - 20); 
					 pGameInternal->LevelOneData.CurrentY = (GAME_HEIGHT - 20); 
					 pGameInternal->LevelOneData.CurrentXInc = (rand() % 3) - 1;
					 pGameInternal->LevelOneData.CurrentYInc = -1*((rand() % 3) + 1);
					 break;

				case MoveLeft: /* Right to Left */
					 pGameInternal->LevelOneData.CurrentX = (GAME_WIDTH - 20);
					 pGameInternal->LevelOneData.CurrentY = rand() % (GAME_HEIGHT - 20); 
					 pGameInternal->LevelOneData.CurrentXInc = -1*((rand() % 3) + 1);
					 pGameInternal->LevelOneData.CurrentYInc = (rand() % 3) - 1;
					 break;

				case MoveRight: /* Left to Right */
					 pGameInternal->LevelOneData.CurrentX = 0; 
					 pGameInternal->LevelOneData.CurrentY = rand() % (GAME_HEIGHT - 20);
					 pGameInternal->LevelOneData.CurrentXInc = (rand() % 3) + 1;
					 pGameInternal->LevelOneData.CurrentYInc = (rand() % 3) - 1;
					 break;
			}

			pGameInternal->LevelOneData.AnimalIndex = rand() % pGameInternal->LevelOneData.NumberOfAnimals;

			pSpriteData = &pGameInternal->LevelOneData.Animal[pGameInternal->LevelOneData.AnimalIndex];
			

			do {
				    pSpriteData->MovementDirection = MovementDirection;

					switch(MovementDirection)
					{
						case MoveDown:
							 if(pSpriteData->StartNumberDown != INVALID_SPRITE_INDEX)
							 {
								 pSpriteData->SpriteIsStanding = FALSE;
								 bFoundSprites = TRUE;
								 pSpriteData->CurrentSprite         = pSpriteData->StartNumberDown;
								 pSpriteData->CurrentLowerBounds    = pSpriteData->StartNumberDown;
								 pSpriteData->CurrentUppferBounds   = pSpriteData->NumberOfAnimations - 1;

								 if(pSpriteData->StartNumberRight != INVALID_SPRITE_INDEX)
								 {
									 pSpriteData->CurrentUppferBounds = pSpriteData->StartNumberRight;
								 }

								 if(pSpriteData->StartNumberLeft != INVALID_SPRITE_INDEX)
								 {
									 pSpriteData->CurrentUppferBounds = pSpriteData->StartNumberLeft;
								 }
							 }
							 else
							 {
								 MovementDirection = MoveRight;
								 if(pGameInternal->LevelOneData.CurrentXInc < 0)
								 {
									 MovementDirection = MoveLeft;
								 }
							 }
							 break;

						case MoveUp:
							 if(pSpriteData->StartNumberUp != INVALID_SPRITE_INDEX)
							 {
								 pSpriteData->SpriteIsStanding = FALSE;
								 bFoundSprites = TRUE;
								 pSpriteData->CurrentSprite         = pSpriteData->StartNumberUp;
								 pSpriteData->CurrentLowerBounds    = pSpriteData->StartNumberUp;
								 pSpriteData->CurrentUppferBounds   = pSpriteData->NumberOfAnimations - 1;

								 if(pSpriteData->StartNumberRight != INVALID_SPRITE_INDEX)
								 {
									 pSpriteData->CurrentUppferBounds = pSpriteData->StartNumberRight;
								 }

								 if(pSpriteData->StartNumberLeft != INVALID_SPRITE_INDEX)
								 {
									 pSpriteData->CurrentUppferBounds = pSpriteData->StartNumberLeft;
								 }

								 if(pSpriteData->StartNumberDown != INVALID_SPRITE_INDEX)
								 {
									 pSpriteData->CurrentUppferBounds = pSpriteData->StartNumberDown;
								 }
							 }
							 else
							 {
								 MovementDirection = MoveRight;
								 if(pGameInternal->LevelOneData.CurrentXInc < 0)
								 {
									 MovementDirection = MoveLeft;
								 }
							 }
							 break;

						case MoveLeft:
							 if(pSpriteData->StartNumberLeft != INVALID_SPRITE_INDEX)
							 {
								 pSpriteData->SpriteIsStanding = FALSE;
								 bFoundSprites = TRUE;
								 pSpriteData->CurrentSprite         = pSpriteData->StartNumberLeft;
								 pSpriteData->CurrentLowerBounds    = pSpriteData->StartNumberLeft;
								 pSpriteData->CurrentUppferBounds   = pSpriteData->NumberOfAnimations - 1;

								 if(pSpriteData->StartNumberRight != INVALID_SPRITE_INDEX)
								 {
									 pSpriteData->CurrentUppferBounds = pSpriteData->StartNumberRight;
								 }

							 }		
							 else
							 {
								 MovementDirection = MoveUp;
								 if(pGameInternal->LevelOneData.CurrentYInc > 0)
								 {
									 MovementDirection = MoveDown;
								 }
							 }
							 break;

						case MoveRight:
							 if(pSpriteData->StartNumberRight != INVALID_SPRITE_INDEX)
							 {
								 pSpriteData->SpriteIsStanding = FALSE;
								 bFoundSprites = TRUE;
								 pSpriteData->CurrentSprite         = pSpriteData->StartNumberRight;
								 pSpriteData->CurrentLowerBounds    = pSpriteData->StartNumberRight;
								 pSpriteData->CurrentUppferBounds   = pSpriteData->NumberOfAnimations - 1;
								 
							 }		
							 else
							 {
								 MovementDirection = MoveUp;
								 if(pGameInternal->LevelOneData.CurrentYInc > 0)
								 {
									 MovementDirection = MoveDown;
								 }
							 }
							 break;
						default:
							 _asm int 3
					}


			} while(bFoundSprites == FALSE) ;
		}
	}

	if(DrawAnimation)
	{
		pSpriteData = &pGameInternal->LevelOneData.Animal[pGameInternal->LevelOneData.AnimalIndex];
		GDI_GetSize(pGameInternal->GameScreen.hGameScreen, &Width, &Height);

		pGameInternal->LevelOneData.AnimalInProgress = GameLevel1_DrawSprite(pSpriteData->phAnimations[pSpriteData->CurrentSprite], (DWORD *)pScreenBuffer, Width, Height, pGameInternal->LevelOneData.CurrentX, pGameInternal->LevelOneData.CurrentY);

		if(pGameInternal->LevelOneData.AnimalInProgress)
		{
			pSpriteData->AnimationPauseCount++;

			if(pSpriteData->AnimationPauseCount >= pSpriteData->AnimationPauses)
			{
			
				pSpriteData->CurrentSprite++;
				if(pSpriteData->CurrentSprite >= pSpriteData->CurrentUppferBounds)
				{
					pSpriteData->CurrentSprite = pSpriteData->CurrentLowerBounds;
				}
			}

			pGameInternal->LevelOneData.CurrentX += pGameInternal->LevelOneData.CurrentXInc;
			pGameInternal->LevelOneData.CurrentY += pGameInternal->LevelOneData.CurrentYInc;
		}
		else
		{
			pGameInternal->LevelOneData.TickOfLastAnimal = TickCount; 
		}
	}
}

 /***********************************************************************
  * GameLevel1_GameLoop
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
BOOL GameLevel1_GameLoop(PGAME_INTERNAL pGameInternal)
{
	UINT TickCount;
	UINT Index;

	if(pGameInternal->GameOptions.EnableSoundEffects)
	{
		TickCount = GetTickCount();
		if(TickCount > pGameInternal->LevelOneData.TickOfLastEffect + TICK_INTERVALS)
		{
			pGameInternal->LevelOneData.TickOfLastEffect = TickCount;
			TAudio_PlaySound(pGameInternal->LevelOneData.hTAudioBGEffects, (rand() % 10));
		}
	}

	Level_MoveSprite(pGameInternal->LevelOneData.hLevel, AMELIA_SPRITE, pGameInternal->LevelOneData.DirectionX, pGameInternal->LevelOneData.DirectionY, pGameInternal->LevelOneData.bDirectionChange);


	for(Index = 0; Index < NUMBER_OF_CATS; Index++)
	{
		GameLevel1_CatAI(pGameInternal, Index);
	}

	for(Index = 0; Index < NUMBER_OF_DOGS; Index++)
	{
		GameLevel1_DogAI(pGameInternal, Index);
	}

	if(GetTickCount() - pGameInternal->LevelOneData.LastUpdateTime > TICKS_PER_SECOND)
	{
		if(pGameInternal->LevelOneData.TimeFreeze)
		{
			pGameInternal->LevelOneData.TimeFreeze -= ((GetTickCount() - pGameInternal->LevelOneData.LastUpdateTime) / TICKS_PER_SECOND);

			if(pGameInternal->LevelOneData.TimeFreeze & 0x80000000)
			{
				pGameInternal->LevelOneData.TimeFreeze = 0;
			}
		}
		else
		{
			pGameInternal->LevelOneData.TimeLimit -= ((GetTickCount() - pGameInternal->LevelOneData.LastUpdateTime) / TICKS_PER_SECOND);
			if(pGameInternal->LevelOneData.TimeLimit & 0x80000000)
			{
				pGameInternal->LevelOneData.TimeLimit = 0;
			}
		}

		pGameInternal->LevelOneData.LastUpdateTime = GetTickCount();

	}


	pGameInternal->LevelOneData.bDirectionChange = FALSE;
	GameLevel1_DrawScreen(pGameInternal);

	//SleepEx(30, TRUE);

	return TRUE;
}


 /***********************************************************************
  * GameLevel1_HandleKeyDown
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_HandleKeyDown(PGAME_INTERNAL pGameInternal, UINT vKey)
{
	int CurrentX = pGameInternal->LevelOneData.DirectionX;
	int CurrentY = pGameInternal->LevelOneData.DirectionY;

	switch(vKey)
	{
		case VK_UP:
			 if(CurrentY != -AMELIA_SPEED || CurrentX != 0)
			 {
				pGameInternal->LevelOneData.DirectionY = -AMELIA_SPEED;
				pGameInternal->LevelOneData.DirectionX = 0;
				pGameInternal->LevelOneData.bDirectionChange = TRUE;
			 }
  			 break;

		case VK_DOWN:
			 if(CurrentY != AMELIA_SPEED || CurrentX != 0)
			 {
				pGameInternal->LevelOneData.DirectionY = AMELIA_SPEED;
				pGameInternal->LevelOneData.DirectionX = 0;
				pGameInternal->LevelOneData.bDirectionChange = TRUE;
			 }
  			 break;

		case VK_LEFT:
			 if(CurrentY != 0 || CurrentX != -AMELIA_SPEED)
			 {
				pGameInternal->LevelOneData.DirectionX = -AMELIA_SPEED;
				pGameInternal->LevelOneData.DirectionY = 0;
				pGameInternal->LevelOneData.bDirectionChange = TRUE;
			 }
  			 break;

		case VK_RIGHT:
			 if(CurrentY != 0 || CurrentX != AMELIA_SPEED)
			 {
				pGameInternal->LevelOneData.DirectionX = AMELIA_SPEED;
				pGameInternal->LevelOneData.DirectionY = 0;
				pGameInternal->LevelOneData.bDirectionChange = TRUE;
			 }
  			 break;

		case VK_CONTROL:
			 pGameInternal->LevelOneData.AutoPilot = !pGameInternal->LevelOneData.AutoPilot;
  			 break;

		default:
     		 pGameInternal->LevelOneData.DirectionX = 0;
             pGameInternal->LevelOneData.DirectionY = 0;
	         pGameInternal->LevelOneData.bDirectionChange = TRUE;
			 break;
	}

	
}

#define RANDOM_YES_NO          ((rand() % 50) >= 25)
#define RANDOM_SMALL_YES_LARGE_NO    ((rand() % 50) >= 40)
#define RANDOM_LARGE_YES_SMALL_NO    ((rand() % 50) >= 10)

 /***********************************************************************
  * GameLevel1_CatAI
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_CatAI(PGAME_INTERNAL pGameInternal, UINT Index)
{
   UINT AmeliaTileX, AmeliaTileY;
   UINT CatTileX, CatTileY;
   UINT DistanceX, DistanceY;

   if(pGameInternal->LevelOneData.CatAi[Index].EngineIsActive)
   {
	   Level_GetCurrentTileLocation(pGameInternal->LevelOneData.hLevel, AMELIA_SPRITE, &AmeliaTileX, &AmeliaTileY);
	   Level_GetCurrentTileLocation(pGameInternal->LevelOneData.hLevel, CAT_SPRITE + Index, &CatTileX, &CatTileY);

	   DistanceX = CatTileX > AmeliaTileX ? CatTileX - AmeliaTileX : AmeliaTileX - CatTileX;
	   DistanceY = CatTileY > AmeliaTileY ? CatTileY - AmeliaTileY : AmeliaTileY - CatTileY;

	   if(pGameInternal->LevelOneData.CatAi[Index].DirectionCounter > 25)
	   {
		   pGameInternal->LevelOneData.CatAi[Index].LastMoveBlockedCounter = 0;
		   pGameInternal->LevelOneData.CatAi[Index].DirectionCounter = 0;
     	   pGameInternal->LevelOneData.CatAi[Index].bDirectionChange = TRUE;
	       pGameInternal->LevelOneData.CatAi[Index].iDirectionX = 0;
		   pGameInternal->LevelOneData.CatAi[Index].iDirectionY = 0;

		   if((DistanceX < 8 && DistanceY < 8) && pGameInternal->LevelOneData.CatAi[Index].LastMoveBlocked == FALSE && RANDOM_LARGE_YES_SMALL_NO)
		   {
			   if(DistanceX < DistanceY)
			   {
				   pGameInternal->LevelOneData.CatAi[Index].iDirectionX = CatTileX > AmeliaTileX ? CAT_RUN_SPEED : -CAT_RUN_SPEED;
			   }
			   else
			   {
				   pGameInternal->LevelOneData.CatAi[Index].iDirectionY = CatTileY > AmeliaTileY ? CAT_RUN_SPEED : -CAT_RUN_SPEED;
			   }
		   }
		   else
		   {
			   if(RANDOM_YES_NO)
			   {
				   pGameInternal->LevelOneData.CatAi[Index].iDirectionX = RANDOM_YES_NO ? -1*((rand()%3) + CAT_MIN_SPEED) : ((rand()%3) + CAT_MIN_SPEED);
			   }
			   else
			   {
				   pGameInternal->LevelOneData.CatAi[Index].iDirectionY = RANDOM_YES_NO ? -1*((rand()%3) + CAT_MIN_SPEED) : ((rand()%3) + CAT_MIN_SPEED);
			   }
		   }
	   }

	   pGameInternal->LevelOneData.CatAi[Index].LastMoveBlocked = FALSE;

	   if(Level_MoveSprite(pGameInternal->LevelOneData.hLevel, CAT_SPRITE + Index, pGameInternal->LevelOneData.CatAi[Index].iDirectionX, pGameInternal->LevelOneData.CatAi[Index].iDirectionY, pGameInternal->LevelOneData.CatAi[Index].bDirectionChange) == FALSE)
	   {
		   pGameInternal->LevelOneData.CatAi[Index].iDirectionX = pGameInternal->LevelOneData.CatAi[Index].iDirectionX*-1;
		   pGameInternal->LevelOneData.CatAi[Index].iDirectionY = pGameInternal->LevelOneData.CatAi[Index].iDirectionY*-1;
		   pGameInternal->LevelOneData.CatAi[Index].LastMoveBlocked = TRUE;
		   pGameInternal->LevelOneData.CatAi[Index].LastMoveBlockedCounter++;
		   pGameInternal->LevelOneData.CatAi[Index].bDirectionChange = TRUE;

		   if(pGameInternal->LevelOneData.CatAi[Index].LastMoveBlockedCounter > 3)
		   {
			   int SwapX, SwapY;

			   SwapX = pGameInternal->LevelOneData.CatAi[Index].iDirectionX;
			   SwapY = pGameInternal->LevelOneData.CatAi[Index].iDirectionY;

    		   pGameInternal->LevelOneData.CatAi[Index].iDirectionX = SwapY;
			   pGameInternal->LevelOneData.CatAi[Index].iDirectionY = SwapX;

			   pGameInternal->LevelOneData.CatAi[Index].LastMoveBlockedCounter = 0;
		   }

		   Level_MoveSprite(pGameInternal->LevelOneData.hLevel, CAT_SPRITE + Index, pGameInternal->LevelOneData.CatAi[Index].iDirectionX, pGameInternal->LevelOneData.CatAi[Index].iDirectionY, pGameInternal->LevelOneData.CatAi[Index].bDirectionChange);
       }
	   
	   pGameInternal->LevelOneData.CatAi[Index].bDirectionChange = FALSE;
	   pGameInternal->LevelOneData.CatAi[Index].DirectionCounter++;
   }
}


 /***********************************************************************
  * GameLevel1_DogAI
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_DogAI(PGAME_INTERNAL pGameInternal, UINT Index)
{
   UINT AmeliaTileX, AmeliaTileY;
   UINT DogTileX, DogTileY;
   UINT DistanceX, DistanceY;

   if(pGameInternal->LevelOneData.DogAi[Index].EngineIsActive)
   {
	   Level_GetCurrentTileLocation(pGameInternal->LevelOneData.hLevel, AMELIA_SPRITE, &AmeliaTileX, &AmeliaTileY);
	   Level_GetCurrentTileLocation(pGameInternal->LevelOneData.hLevel, DOG_SPRITE + Index, &DogTileX, &DogTileY);

	   DistanceX = DogTileX > AmeliaTileX ? DogTileX - AmeliaTileX : AmeliaTileX - DogTileX;
	   DistanceY = DogTileY > AmeliaTileY ? DogTileY - AmeliaTileY : AmeliaTileY - DogTileY;

	   if(pGameInternal->LevelOneData.DogAi[Index].DirectionCounter > 25)
	   {
		   pGameInternal->LevelOneData.DogAi[Index].LastMoveBlockedCounter = 0;
		   pGameInternal->LevelOneData.DogAi[Index].DirectionCounter = 0;
     	   pGameInternal->LevelOneData.DogAi[Index].bDirectionChange = TRUE;
	       pGameInternal->LevelOneData.DogAi[Index].iDirectionX = 0;
		   pGameInternal->LevelOneData.DogAi[Index].iDirectionY = 0;

		   if((DistanceX < 8 && DistanceY < 8) && pGameInternal->LevelOneData.DogAi[Index].LastMoveBlocked == FALSE && RANDOM_LARGE_YES_SMALL_NO)
		   {
			   if(DistanceX < DistanceY)
			   {
				   pGameInternal->LevelOneData.DogAi[Index].iDirectionX = DogTileX > AmeliaTileX ? DOG_RUN_SPEED : -DOG_RUN_SPEED;
			   }
			   else
			   {
				   pGameInternal->LevelOneData.DogAi[Index].iDirectionY = DogTileY > AmeliaTileY ? DOG_RUN_SPEED : -DOG_RUN_SPEED;
			   }
		   }
		   else
		   {
			   if(RANDOM_YES_NO)
			   {
				   pGameInternal->LevelOneData.DogAi[Index].iDirectionX = RANDOM_YES_NO ? -1*((rand()%3) + DOG_MIN_SPEED) : ((rand()%3) + DOG_MIN_SPEED);
			   }
			   else
			   {
				   pGameInternal->LevelOneData.DogAi[Index].iDirectionY = RANDOM_YES_NO ? -1*((rand()%3) + DOG_MIN_SPEED) : ((rand()%3) + DOG_MIN_SPEED);
			   }
		   }
	   }

	   pGameInternal->LevelOneData.DogAi[Index].LastMoveBlocked = FALSE;

	   if(Level_MoveSprite(pGameInternal->LevelOneData.hLevel, DOG_SPRITE + Index, pGameInternal->LevelOneData.DogAi[Index].iDirectionX, pGameInternal->LevelOneData.DogAi[Index].iDirectionY, pGameInternal->LevelOneData.DogAi[Index].bDirectionChange) == FALSE)
	   {
		   pGameInternal->LevelOneData.DogAi[Index].iDirectionX = pGameInternal->LevelOneData.DogAi[Index].iDirectionX*-1;
		   pGameInternal->LevelOneData.DogAi[Index].iDirectionY = pGameInternal->LevelOneData.DogAi[Index].iDirectionY*-1;
		   pGameInternal->LevelOneData.DogAi[Index].LastMoveBlocked = TRUE;
		   pGameInternal->LevelOneData.DogAi[Index].LastMoveBlockedCounter++;
		   pGameInternal->LevelOneData.DogAi[Index].bDirectionChange = TRUE;

		   if(pGameInternal->LevelOneData.DogAi[Index].LastMoveBlockedCounter > 3)
		   {
			   int SwapX, SwapY;

			   SwapX = pGameInternal->LevelOneData.DogAi[Index].iDirectionX;
			   SwapY = pGameInternal->LevelOneData.DogAi[Index].iDirectionY;

    		   pGameInternal->LevelOneData.DogAi[Index].iDirectionX = SwapY;
			   pGameInternal->LevelOneData.DogAi[Index].iDirectionY = SwapX;

			   pGameInternal->LevelOneData.DogAi[Index].LastMoveBlockedCounter = 0;
		   }

		   Level_MoveSprite(pGameInternal->LevelOneData.hLevel, DOG_SPRITE + Index, pGameInternal->LevelOneData.DogAi[Index].iDirectionX, pGameInternal->LevelOneData.DogAi[Index].iDirectionY, pGameInternal->LevelOneData.DogAi[Index].bDirectionChange);
       }
	   
	   pGameInternal->LevelOneData.DogAi[Index].bDirectionChange = FALSE;
	   pGameInternal->LevelOneData.DogAi[Index].DirectionCounter++;
   }
}




 /***********************************************************************
  * GameLevel1_SpriteCatCollision
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_SpriteCatCollision(PGAME_INTERNAL pGameInternal, DWORD dwSpriteId)
{
	if(pGameInternal->GameOptions.EnableSoundEffects)
	{
		TAudio_PlaySound(pGameInternal->LevelOneData.hTAudioEffects, (rand() % CAT_NUMBER_EFFECTS) + CAT_EFFECT_START);
	}

	pGameInternal->LevelOneData.GameScore += CAT_POINTS;
	pGameInternal->LevelOneData.CatAi[dwSpriteId - CAT_SPRITE].EngineIsActive = FALSE;
	Level_DeleteSprite(pGameInternal->LevelOneData.hLevel, dwSpriteId);
	pGameInternal->LevelOneData.CatsCaptured++;
}



 /***********************************************************************
  * GameLevel1_SpriteCatCollision
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_SpriteDogCollision(PGAME_INTERNAL pGameInternal, DWORD dwSpriteId)
{
	if(pGameInternal->GameOptions.EnableSoundEffects)
	{
		TAudio_PlaySound(pGameInternal->LevelOneData.hTAudioEffects, (rand() % DOG_NUMBER_EFFECTS) + DOG_EFFECT_START);
	}

	pGameInternal->LevelOneData.GameScore += DOG_POINTS;
	pGameInternal->LevelOneData.DogAi[dwSpriteId - DOG_SPRITE].EngineIsActive = FALSE;
	Level_DeleteSprite(pGameInternal->LevelOneData.hLevel, dwSpriteId);
	pGameInternal->LevelOneData.DogsCaptured++;
}

 /***********************************************************************
  * GameLevel1_SpriteCatCollision
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_SpriteAlphabetCollision(PGAME_INTERNAL pGameInternal, DWORD dwSpriteId)
{
	if(pGameInternal->GameOptions.EnableSoundEffects)
	{
		TAudio_PlaySound(pGameInternal->LevelOneData.hTAudioEffects, (rand() % ALPHABET_NUMBER_EFFECTS) + ALPHABET_EFFECT_START);
	}

	pGameInternal->LevelOneData.GameScore += ALPHABET_POINTS(dwSpriteId - ALPHABET_SPRITE);
	Level_DeleteSprite(pGameInternal->LevelOneData.hLevel, dwSpriteId);
	pGameInternal->LevelOneData.AlphabetCaptured++;
}





 /***********************************************************************
  * GameLevel1_SpriteCollision
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_SpriteCollision(HLEVEL hLevel, PVOID pContext, DWORD dwSpriteId)
{
	PGAME_INTERNAL pGameInternal = (PGAME_INTERNAL)pContext;

	if(dwSpriteId >= CAT_SPRITE && dwSpriteId <= CAT_SPRITE + NUMBER_OF_CATS)
	{
	     GameLevel1_SpriteCatCollision(pGameInternal, dwSpriteId);
	}

	if(dwSpriteId >= DOG_SPRITE && dwSpriteId <= DOG_SPRITE + NUMBER_OF_DOGS)
	{
	     GameLevel1_SpriteDogCollision(pGameInternal, dwSpriteId);
	}

	if(dwSpriteId >= ALPHABET_SPRITE && dwSpriteId <= ALPHABET_SPRITE + NUMBER_OF_ALPHABET)
	{
	     GameLevel1_SpriteAlphabetCollision(pGameInternal, dwSpriteId);
	}
	
}

 /***********************************************************************
  * GameLevel1_HandleKeyUp
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_HandleKeyUp(PGAME_INTERNAL pGameInternal, UINT vKey)
{
	if(pGameInternal->LevelOneData.AutoPilot == FALSE)
	{
		pGameInternal->LevelOneData.DirectionX = 0;
		pGameInternal->LevelOneData.DirectionY = 0;
		pGameInternal->LevelOneData.bDirectionChange        = TRUE;
	}
}

 /***********************************************************************
  * GameLevel1_DrawSprite
  *  
  *   Draw a sprite
  *
  * Parameters
  *     instance Handle, Window Handle
  * 
  * Return Value
  *     Exit Value
  *
  ***********************************************************************/
BOOL GameLevel1_DrawSprite(HGDI hImageGDI, DWORD *pScreen, UINT ScreenWidth, UINT ScreenHeight, UINT ImageX, UINT ImageY)
{
	BOOL ImageWasDrawn = FALSE;
	DWORD *pSpriteImage;
	UINT IndexX, IndexY;
	UINT SpriteWidth, SpriteHeight;
	DWORD SkipColor;
	UINT CalculatedLocationX;
	UINT CalculatedLocationY;


	GDI_GetSize(hImageGDI, &SpriteWidth, &SpriteHeight);
	pSpriteImage = (DWORD *)GDI_BeginPaint(hImageGDI);

	SkipColor = *pSpriteImage;

	for(IndexY = 0; IndexY < SpriteHeight; IndexY++)
	{
		for(IndexX = 0; IndexX < SpriteWidth; IndexX++, pSpriteImage++)
		{
			if(SkipColor != *pSpriteImage)
			{
				CalculatedLocationX = ImageX + IndexX;
				CalculatedLocationY = ImageY + IndexY;

				if(CalculatedLocationX < ScreenWidth && CalculatedLocationY < ScreenHeight)
				{
					ImageWasDrawn = TRUE;
					pScreen[(CalculatedLocationX) + (CalculatedLocationY*ScreenWidth)] = *pSpriteImage;
				}
			}
		}
	}

	GDI_EndPaint(hImageGDI);

	return ImageWasDrawn;
}


/***********************************************************************
 * GameLevel1_GetRandomTileCoordinates
 *  
 *    Debug 
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
void GameLevel1_GetRandomTileCoordinates(PGAME_INTERNAL pGameInternal, UINT *pTileX, UINT *pTileY)
{
	UINT TileX, TileY;
	BOOL FoundGoodLocation = FALSE;

	do {
		TileX = rand()%pGameInternal->LevelOneData.LevelOneMap.MapResolutionX;
		TileY = rand()%pGameInternal->LevelOneData.LevelOneMap.MapResolutionY;

		if((pGameInternal->LevelOneData.LevelOneMap.MapData[TileX + TileY*pGameInternal->LevelOneData.LevelOneMap.MapResolutionX] & (2<<24)) == 0)
		{
			FoundGoodLocation = TRUE;
		}

	} while(FoundGoodLocation == FALSE);

    *pTileX = TileX;
	*pTileY = TileY;
}

/***********************************************************************
 * GameLevel1_Debug
 *  
 *    Debug 
 *
 *    
 *
 * Parameters
 *     Debug
 *
 * Return Value
 *     Nothing
 *
 ***********************************************************************/
 void GameLevel1_Debug(char *pszFormatString, ...)
 {
     char DebugString[256];
     va_list vl;

     va_start(vl, pszFormatString);
     vsprintf(DebugString, pszFormatString, vl);
     va_end(vl);

     OutputDebugStringA(DebugString);
 }

 /***********************************************************************
  * GameLevel1_GameLoop
  *  
  *    
  *
  * Parameters
  *     
  * 
  * Return Value
  *     
  *
  ***********************************************************************/
void GameLevel1_DrawScreen(PGAME_INTERNAL pGameInternal)
{
	HDC hDC;
	char szGameBufferText[100];
	Level_UpdateScreen(pGameInternal->LevelOneData.hLevel);

    hDC = GDI_GetDC(pGameInternal->GameScreen.hGameScreen);
	
    SetBkMode(hDC, TRANSPARENT);                            
    SetTextColor(hDC, 0xFFFFFF);
	
	sprintf(szGameBufferText, "Cats Captured %i out of %i", pGameInternal->LevelOneData.CatsCaptured, NUMBER_OF_CATS);
	TextOut(hDC, 10, 10, szGameBufferText, strlen(szGameBufferText));

	sprintf(szGameBufferText, "Dogs Captured %i out of %i", pGameInternal->LevelOneData.DogsCaptured, NUMBER_OF_DOGS);
	TextOut(hDC, 10, 25, szGameBufferText, strlen(szGameBufferText));

	sprintf(szGameBufferText, "Alphabet Collected %i out of %i", pGameInternal->LevelOneData.AlphabetCaptured, NUMBER_OF_ALPHABET);
	TextOut(hDC, 10, 40, szGameBufferText, strlen(szGameBufferText));

	sprintf(szGameBufferText, "Score %i", pGameInternal->LevelOneData.GameScore);
	TextOut(hDC, 650, 10, szGameBufferText, strlen(szGameBufferText));

	sprintf(szGameBufferText, "Seconds Left %i", pGameInternal->LevelOneData.TimeLimit);
	TextOut(hDC, 650, 25, szGameBufferText, strlen(szGameBufferText));

    GDI_ReleaseDC(pGameInternal->GameScreen.hGameScreen);
	
	InvalidateRect(pGameInternal->hWnd, NULL, FALSE);
}

#if 0

#define Ti(X, Y, F) ((X + Y*16) | (F<<24))

/*
 * The Level One Game Map (FUTURE: Put into a resource/file)
 */

DWORD g_LevelOneMap_TEMP[] =
{
	Ti(2, 1, 2), Ti(5, 1, 2),  Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2),  Ti(3, 1, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(1, 0, 2), Ti(0, 0, 2),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 1, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(1, 0, 2), Ti(0, 0, 2),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 1, 2),  Ti(6, 0, 2),  Ti(5, 0, 2),  Ti(3, 2, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(1, 0, 2), Ti(0, 0, 2),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 2, 2),  Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(1, 0, 2), Ti(0, 0, 2),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 2, 2),  Ti(0, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2), Ti(0, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(1, 0, 2), Ti(0, 0, 2),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 2, 2),  Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2), Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2), Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2), Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2), Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2), Ti(6, 1, 2),  Ti(5, 1, 2),  Ti(6, 1, 2), Ti(6, 1, 2), Ti(5, 1, 2), Ti(6, 1, 2),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 16, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 17, 2), Ti(1, 16, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(3, 20, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 18, 2), Ti(1, 17, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(3, 21, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 19, 2), Ti(1, 18, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(3, 22, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(1, 19, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(3, 23, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 16, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(1, 16, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 24, 2),Ti(4, 24, 2), Ti(4, 24, 2), Ti(4, 24, 2),Ti(4, 24, 2),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 17, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(1, 17, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 24, 2),Ti(10, 26, 0), Ti(10, 26, 0), Ti(10, 26, 0),Ti(4, 24, 2),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 18, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(1, 18, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 24, 2),Ti(10, 26, 0), Ti(10, 26, 0), Ti(10, 26, 0),Ti(4, 24, 2),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(2, 20, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(0, 19, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(1, 19, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 24, 2),Ti(10, 26, 0), Ti(10, 26, 0), Ti(10, 26, 0),Ti(4, 24, 2),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(2, 21, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 24, 2),Ti(10, 26, 0), Ti(10, 26, 0), Ti(10, 26, 0),Ti(4, 24, 2),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(2, 22, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 24, 2),Ti(9, 26, 0), Ti(10, 26, 0), Ti(10, 26, 0),Ti(4, 24, 2),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(2, 2, 2), Ti(1, 1, 2),  Ti(14, 7, 0), Ti(14, 7, 0), Ti(2, 23, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 24, 2),Ti(8, 26, 0), Ti(9, 26, 0), Ti(10, 26, 0),Ti(4, 24, 2),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(0, 0, 2), Ti(3, 0, 2),  Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(2, 24, 2),Ti(1, 24, 2), Ti(7, 24, 0), Ti(2, 24, 2),Ti(2, 24, 2),Ti(14, 7, 0),Ti(14, 7, 0),
    Ti(2, 0, 2), Ti(2, 2, 2),  Ti(1, 1, 2),  Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(0, 27, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(3, 0, 2),  Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(1, 27, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(2, 0, 2), Ti(0, 0, 2),  Ti(4, 0, 2),  Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(2, 27, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),    
	Ti(0, 0, 2), Ti(2, 0, 2),  Ti(3, 0, 2),  Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(0, 27, 0), Ti(1, 27, 0),Ti(2, 27, 0), Ti(2, 27, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),    
	Ti(1, 0, 2), Ti(1, 0, 2),  Ti(4, 0, 2),  Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(0, 27, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),    
	Ti(1, 0, 2), Ti(0, 0, 2),  Ti(2, 2, 2),  Ti(5, 0, 2),  Ti(6, 0, 2),  Ti(5, 0, 2),  Ti(6, 0, 2),  Ti(5, 0, 2),  Ti(6, 0, 2),  Ti(1, 1, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(1, 27, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),   
	Ti(0, 0, 2), Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2), Ti(0, 0, 2),  Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),  Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(2, 27, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),  
	Ti(2, 0, 2), Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(0, 0, 2), Ti(2, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),   Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(1, 27, 0), Ti(0, 27, 0), Ti(14, 7, 0),Ti(2, 20, 2), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0), 
	Ti(1, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(2, 0, 2), Ti(1, 0, 2), Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),   Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(2, 21, 2), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0), 
	Ti(0, 0, 2), Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(1, 0, 2), Ti(3, 5, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),   Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(2, 22, 2), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0), 
	Ti(2, 0, 2), Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(3, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),   Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(2, 23, 2), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0), 
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),   Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0), 
	Ti(2, 0, 2), Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(3, 0, 2), Ti(14, 7, 0), Ti(4, 19, 2), Ti(5, 19, 2), Ti(5, 19, 2), Ti(7, 19, 2), Ti(14, 7, 0),   Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0), 
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(4, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0),   Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0), 
	Ti(2, 0, 2), Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(3, 0, 2), Ti(14, 7, 0), Ti(4, 21, 2), Ti(5, 21, 2), Ti(6, 21, 2), Ti(7, 21, 2), Ti(14, 7, 0),    Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(4, 22, 2), Ti(5, 22, 2), Ti(6, 22, 2), Ti(7, 22, 2), Ti(14, 7, 0),    Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(2, 0, 2), Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(3, 0, 2), Ti(14, 7, 0), Ti(4, 23, 2), Ti(5, 23, 2), Ti(6, 23, 2), Ti(7, 23, 2), Ti(14, 7, 0),    Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(7, 4, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(4, 19, 2), Ti(5, 19, 2), Ti(6, 19, 2), Ti(5, 19, 2), Ti(6, 19, 2), Ti(5, 19, 2), Ti(6, 19, 2), Ti(5, 19, 2), Ti(6, 19, 2),Ti(5, 19, 2), Ti(6, 19, 2), Ti(5, 19, 2), Ti(6, 19, 2), Ti(5, 19, 2), Ti(6, 19, 2),Ti(5, 19, 2), Ti(6, 19, 2), Ti(5, 19, 2), Ti(7, 19, 2), Ti(14, 7, 0), Ti(4, 19, 2),Ti(5, 19, 2), Ti(6, 19, 2),Ti(7, 19, 2),
	Ti(2, 0, 2), Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(3, 0, 2), Ti(4, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(4, 21, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(2, 0, 2), Ti(2, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2), Ti(1, 0, 2), Ti(3, 0, 2), Ti(4, 22, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(4, 23, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2), 
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(14, 7, 0),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(14, 7, 0),Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0), Ti(14, 7, 0),Ti(5, 20, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(14, 7, 0),Ti(14, 7, 0), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(14, 7, 0),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(14, 7, 0), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2),
	Ti(0, 0, 2), Ti(0, 0, 2),  Ti(2, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2),  Ti(0, 0, 2),  Ti(1, 0, 2),  Ti(2, 0, 2), Ti(0, 0, 2), Ti(4, 0, 2), Ti(14, 7, 0), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(6, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2), Ti(5, 20, 2), Ti(7, 20, 2), Ti(14, 7, 0), Ti(4, 20, 2),Ti(5, 20, 2), Ti(6, 20, 2),Ti(7, 20, 2)

};

#endif