;*********************************************************
; Cube
;  Written in Assembly using Direct X 8 for WIN32
;
;  Toby Opferman
;    Copyright (c) 2004 All Rights Reserved
;
;
;
;*********************************************************
;       D I S C L A I M E R  AND  L I C E N S E    
;   
; I license out this code for educational use only.
; There are no warranties implied.  Use at your own RISK.  
; I am NOT responsible for any catastrophic results which 
; may occur from using or replicating of this code in any
; shape or form.
;    
; Free to use this code for reference as an educational  
; tool only.  If you use any of the subroutines give credit
; where credit is due.  
;
; You may not use any of this source for commerical use
; without notifying the author for permission.
;
;*********************************************************

.386
.MODEL FLAT, STDCALL
OPTION CASEMAP :NONE

;
; Includes
;
;INCLUDE WINDOWS.INC
INCLUDE D3D8.INC
;INCLUDE USER32.INC
INCLUDELIB USER32.LIB       
INCLUDELIB D3D8.LIB
;
; Prototypes
;
SetCursor PROTO :DWORD
CreateWindowExA PROTO :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD, :DWORD
GetAsyncKeyState PROTO :DWORD

;
; Equates
;
EQU_HEIGHT  EQU <300>
EQU_WIDTH   EQU <400>

VK_ESCAPE   EQU <1Bh>
D3DFMT_P8   EQU <41>

IDirect3D8_CreateDevice                EQU <3Ch>
IDirect3DDevice8_Present               EQU <3Ch>
IDirect3DDevice8_GetBackBuffer         EQU <40h>
IDirect3DSurface8_LockRect             EQU <24h>
IDirect3DSurface8_UnlockRect           EQU <28h>
;
; Offset To Variables
;
lpD3DDevice   EQU <EBP + 0>
lpDirect3d    EQU <EBP + 4>

PresentParams EQU <EBP + 8>
  PresentParams_Width                            EQU <EBP + 8>
  PresentParams_Height                           EQU <EBP + 12>
  PresentParams_Format                           EQU <EBP + 16>
  PresentParams_Count                            EQU <EBP + 20>
  PresentParams_MultiSampleType                  EQU <EBP + 24>
  PresentParams_SwapEffect                       EQU <EBP + 28>
  PresentParams_hDeviceWindow                    EQU <EBP + 32>
  PresentParams_Windowed                         EQU <EBP + 36>
  PresentParams_EnableAutoDepthStencil           EQU <EBP + 40>
  PresentParams_AutoDepthStencilFormat           EQU <EBP + 44>
  PresentParams_Flags                            EQU <EBP + 48>
  PresentParams_FullScreen_RefreshRateInHz       EQU <EBP + 52>
  PresentParams_FullScreen_PresentationInterval  EQU <EBP + 56>

lpD3DBack     EQU <EBP + 60>

D3dLockedRect EQU <EBP + 64>
  D3dLockedRect_Pitch EQU <EBP + 64>
  D3dLockedRect_pBits EQU <EBP + 68>

RotateFlag EQU <EBP + 72> 
Temp EQU <EBP + 74>

SX1 EQU <EBP + 80>
SY1 EQU <EBP + 84>

SX2 EQU <EBP + 88>
SY2 EQU <EBP + 92>

SX3 EQU <EBP + 96>
SY3 EQU <EBP + 100>

SX4 EQU <EBP + 104>
SY4 EQU <EBP + 108>

SX5 EQU <EBP + 112>
SY5 EQU <EBP + 116>

SX6 EQU <EBP + 120>
SY6 EQU <EBP + 124>

SX7 EQU <EBP + 128>
SY7 EQU <EBP + 132>

SX8 EQU <EBP + 136>
SY8 EQU <EBP + 140>

X_INC EQU <EBP + 144>
Y_INC EQU <EBP + 148>

TempY EQU <EBP + 152>
TempX EQU <EBP + 156>

TempY2 EQU <EBP + 160>
TempX2 EQU <EBP + 164>

Error EQU <EBP + 168>

DeltaY EQU <EBP + 172>
DeltaX EQU <EBP + 176>

.CODE
START:
    
    MOV EBP, 400A00h 
        
    PUSH EAX            
    
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH OFFSET szEdit
    PUSH EAX
    CALL CreateWindowExA

    XCHG EAX, EBX
    
    CALL SetCursor
    
    PUSH D3D_SDK_VERSION
    CALL Direct3DCreate8
    
    MOV DWORD PTR [lpDirect3d], EAX
    
    MOV BYTE PTR [PresentParams_Format], D3DFMT_X8R8G8B8 
    MOV WORD PTR [PresentParams_Height], EQU_HEIGHT
    MOV WORD PTR [PresentParams_Width],  EQU_WIDTH
    
    INC DWORD PTR [PresentParams_Flags]
    INC DWORD PTR [PresentParams_SwapEffect]
    
    LEA  ECX, [PresentParams]
    PUSH EBP
    PUSH ECX
    PUSH D3DCREATE_SOFTWARE_VERTEXPROCESSING
    PUSH EBX
    PUSH D3DDEVTYPE_HAL
    PUSH D3DADAPTER_DEFAULT
    MOV EBX, [lpDirect3d]
    PUSH EBX                                    
    MOV EBX, [EBX]
    CALL DWORD PTR [EBX + IDirect3D8_CreateDevice]
    
    
    LEA EDX, [lpD3DBack]
    PUSH EDX
    PUSH EAX
    PUSH EAX
    MOV EBX, [lpD3DDevice]
    PUSH EBX
    MOV EBX, [EBX]
    CALL DWORD PTR [EBX + IDirect3DDevice8_GetBackBuffer]

DemoGraphicsLoop:
    
    LEA ECX, [D3dLockedRect]
    PUSH EAX
    PUSH EAX
    PUSH ECX
    MOV EBX, [lpD3DBack]
    PUSH EBX
    MOV EBX, [EBX]
    CALL DWORD PTR [EBX + IDirect3DSurface8_LockRect]

    MOV EDI, [D3dLockedRect_pBits]
    PUSH EQU_HEIGHT / 4
    POP ECX
    IMUL ECX, [D3dLockedRect_Pitch]
    REP STOSD
    
    PUSH EBX
    
    ; Demo Begins Here
    
    ;
    ; Rotations
    ;
    
    MOV ECX, 8
    MOV EDI, OFFSET PX1 
  
  RotationLoop:
    ;     Around Z Axis
    ; nx = x*cos(t) - y*sin(t)
    ; ny = y*cos(t) + x*sin(t)
    CMP BYTE PTR [RotateFlag], 255/3
    JB @RotateXAxis
    
    CMP BYTE PTR [RotateFlag], 255/3 + 255/3
    JB @RotateYAxis
    
    FLD DWORD PTR [EDI + 4]
    FMUL [SIN_1r]
    
    FLD DWORD PTR [EDI]
    FMUL [COS_1r]
    
    FSUBR

    FLD DWORD PTR [EDI + 4]
    FMUL [COS_1r]
    
    FLD DWORD PTR [EDI]
    FMUL [SIN_1r]
    
    FADD
    FSTP DWORD PTR [EDI + 4]
    FSTP DWORD PTR [EDI]
    
    JMP @FinishLoop
    
    ;     Around X Axis
    ; ny = y*cos(t) - z*sin(t)
    ; nz = z*cos(t) + y*sin(t)
   @RotateXAxis:

   
    FLD DWORD PTR [EDI + 8]
    FMUL [SIN_1r]
    
    FLD DWORD PTR [EDI + 4]
    FMUL [COS_1r]
    
    FSUBR

    FLD DWORD PTR [EDI + 8]
    FMUL [COS_1r]
    
    FLD DWORD PTR [EDI + 4]
    FMUL [SIN_1r]
    
    FADD
    FSTP DWORD PTR [EDI + 8]
    FSTP DWORD PTR [EDI + 4]    
    JMP @FinishLoop
    ;     Around Y Axis
    ; nx = x*cos(t) - z*sin(t)
    ; nz = z*cos(t) + x*sin(t)
   @RotateYAxis:
    FLD DWORD PTR [EDI + 8]
    FMUL [SIN_1r]
    
    FLD DWORD PTR [EDI]
    FMUL [COS_1r]
    
    FSUBR

    FLD DWORD PTR [EDI + 8]
    FMUL [COS_1r]
    
    FLD DWORD PTR [EDI]
    FMUL [SIN_1r]
    
    FADD
    FSTP DWORD PTR [EDI + 8]
    FSTP DWORD PTR [EDI]
    
   @FinishLoop:
    ADD EDI, 12
    DEC ECX
    JNZ RotationLoop
 
  
    MOV ECX, 8
    MOV EDI, OFFSET PX1
    LEA ESI, [SX1]
    
  PlotPoints:     
    ;
    ; ScreenX = CameraX*VIEW/CameraZ + HalfScreenWidth
    ;
    ;   We have no camera.  World cooridinates are 0, 0, 300
    ;   Aspect = 1, VIEW = 256
    ;

    
    FLD DWORD PTR [EDI]
    FMUL [VIEW]
    FLD DWORD PTR [EDI + 8]
    FADD [ZWORLD]
    FDIV
    FISTP DWORD PTR [ESI]
    
;    MOV EDX, [ESI]
    ADD  DWORD PTR [ESI], EQU_WIDTH / 2
   ; MOV EDX, [ESI]
   ; SHL EDX, 2
    
    ;
    ; ScreenY = HalfHeight - CameraY*ASPECT*VIEW/CameraZ
    ;
        
    FLD DWORD PTR [EDI + 4]
    FMUL [VIEW]
    FLD DWORD PTR [EDI + 8]
    FADD [ZWORLD]
    FDIV
    FISTP DWORD PTR [ESI + 4]
    
    MOV EBX, EQU_HEIGHT / 2
    SUB EBX, [ESI + 4]
    MOV [ESI + 4], EBX
;    IMUL EBX, [D3dLockedRect_Pitch]
    
;    ADD EBX, EDX
    
 ;   MOV EAX, 0FFFFFFh
    
;    MOV EDX, [D3dLockedRect_pBits]
;    MOV [EBX + EDX], EAX
    
    ADD EDI, 12
    ADD ESI, 8
    LOOP PlotPoints
    
    LEA ESI, [SX1]
    MOV ECX, 6
    
   @DrawLines:
   
    PUSH ECX
    PUSH ESI
    
    CALL LINE
    
    POP ESI
    POP ECX
    
    ADD ESI, 8
    LOOP @DrawLines
    
    MOV EAX, [SY1]
    MOV [TempY], EAX
    MOV EAX, [SX1]
    MOV [TempX], EAX
 
    MOV EAX, [SY2]
    MOV [TempY2], EAX
    MOV EAX, [SX2]
    MOV [TempX2], EAX
    
    CALL LINE
    
    MOV EAX, [SY2]
    MOV [TempY], EAX
    MOV EAX, [SX2]
    MOV [TempX], EAX
 
    MOV EAX, [SY4]
    MOV [TempY2], EAX
    MOV EAX, [SX4]
    MOV [TempX2], EAX
    CALL LINE
    
    MOV EAX, [SY3]
    MOV [TempY], EAX
    MOV EAX, [SX3]
    MOV [TempX], EAX
 
    MOV EAX, [SY4]
    MOV [TempY2], EAX
    MOV EAX, [SX4]
    MOV [TempX2], EAX
    CALL LINE
    MOV EAX, [SY3]
    MOV [TempY], EAX
    MOV EAX, [SX3]
    MOV [TempX], EAX
 
    MOV EAX, [SY1]
    MOV [TempY2], EAX
    MOV EAX, [SX1]
    MOV [TempX2], EAX
    CALL LINE    

    MOV EAX, [SY1]
    MOV [TempY], EAX
    MOV EAX, [SX1]
    MOV [TempX], EAX
 
    MOV EAX, [SY5]
    MOV [TempY2], EAX
    MOV EAX, [SX5]
    MOV [TempX2], EAX
    CALL LINE
    
    MOV EAX, [SY2]
    MOV [TempY], EAX
    MOV EAX, [SX2]
    MOV [TempX], EAX
 
    MOV EAX, [SY6]
    MOV [TempY2], EAX
    MOV EAX, [SX6]
    MOV [TempX2], EAX
    CALL LINE
    
    MOV EAX, [SY3]
    MOV [TempY], EAX
    MOV EAX, [SX3]
    MOV [TempX], EAX
 
    MOV EAX, [SY7]
    MOV [TempY2], EAX
    MOV EAX, [SX7]
    MOV [TempX2], EAX
    CALL LINE
    
    MOV EAX, [SY4]
    MOV [TempY], EAX
    MOV EAX, [SX4]
    MOV [TempX], EAX
 
    MOV EAX, [SY8]
    MOV [TempY2], EAX
    MOV EAX, [SX8]
    MOV [TempX2], EAX
    CALL LINE
    
    MOV EAX, [SY6]
    MOV [TempY], EAX
    MOV EAX, [SX6]
    MOV [TempX], EAX
 
    MOV EAX, [SY5]
    MOV [TempY2], EAX
    MOV EAX, [SX5]
    MOV [TempX2], EAX
    CALL LINE
    
    MOV EAX, [SY5]
    MOV [TempY], EAX
    MOV EAX, [SX5]
    MOV [TempX], EAX
 
    MOV EAX, [SY7]
    MOV [TempY2], EAX
    MOV EAX, [SX7]
    MOV [TempX2], EAX
    CALL LINE
   
    MOV EAX, [SY7]
    MOV [TempY], EAX
    MOV EAX, [SX7]
    MOV [TempX], EAX

    MOV EAX, [SY8]
    MOV [TempY2], EAX
    MOV EAX, [SX8]
    MOV [TempX2], EAX
    CALL LINE
    
    MOV EAX, [SY8]
    MOV [TempY], EAX
    MOV EAX, [SX8]
    MOV [TempX], EAX
    MOV EAX, [SY6]
    MOV [TempY2], EAX
    MOV EAX, [SX6]
    MOV [TempX2], EAX
    CALL LINE
    
    
    
    
    

    
    ; Demo Ends Here
    INC DWORD PTR [RotateFlag]
    POP  EBX
    
    PUSH [lpD3DBack]
    CALL DWORD PTR [EBX + IDirect3DSurface8_UnlockRect]
    
    PUSH EAX
    PUSH EAX
    PUSH EAX
    PUSH EAX
    MOV EBX, [lpD3DDevice]
    PUSH EBX
    MOV EBX, [EBX]
    CALL DWORD PTR [EBX + IDirect3DDevice8_Present]

    PUSH VK_ESCAPE
    CALL GetAsyncKeyState
    TEST EAX, EAX
    JZ DemoGraphicsLoop
   
ExitProgram:
    RET

LINE PROC
  
;    IMUL EBX, [D3dLockedRect_Pitch]
    
;    ADD EBX, EDX
    
;    MOV EAX, 0FFFFFFh
    
;    MOV EDX, [D3dLockedRect_pBits]
;    MOV [EBX + EDX], EAX

  MOV EDI, [D3dLockedRect_pBits]
  MOV EAX, [TempX]
  SHL EAX, 2  
  ADD EDI, EAX
  
  MOV ECX, [TempY]
  IMUL ECX, [D3dLockedRect_Pitch]
  ADD EDI, ECX
  
  XOR EAX, EAX
  
  MOV [Error], EAX

  MOV EAX, [TempX2]                        ; Set Delta X
  SUB EAX, [TempX]
  MOV [DeltaX], EAX

  MOV EAX, [TempY2]                        ; Set Delta Y
  SUB EAX, [TempY]
  MOV [DeltaY], EAX

  MOV EAX, 4                             ; Set X_INC To 1
  MOV [X_INC], EAX
  MOV EAX, [D3dLockedRect_Pitch]         ; Set Y_INC To Pitch
  MOV [Y_INC], EAX

  XOR EAX, EAX                            ; Test Delta X Against 0
  CMP [DeltaX], EAX
  JGE SHORT SKIP1
  NEG DWORD PTR [X_INC]                             ; Negate Them
  NEG DWORD PTR [DeltaX]

  SKIP1:
  CMP [DeltaY], EAX                        ; Test DeltaY Against Zero
  JGE SHORT SKIP2
  NEG DWORD PTR [Y_INC]                             ; Negate Them
  NEG DWORD PTR [DeltaY]

  SKIP2:
  MOV EAX, [DeltaY]
  CMP [DeltaX], EAX                        ; DeltaX > DeltaY?
  JLE SHORT ELSE1
  MOV ECX, [DeltaX]                        ; Loop DeltaX Times
  INC ECX
  THEN:
    DEC ECX
    MOV DWORD PTR [EDI], 0FFFFFFh                ; Set Color

    MOV EAX, [DeltaY]                      ; Set Error
    ADD [Error], EAX
    MOV EAX, [Error]

    CMP EAX, [DeltaX]                      ; Error>DeltaX
    JLE SHORT AGAIN
     SUB EAX, [DeltaX]                     ; Error -= DeltaX
     MOV [Error], EAX
     ADD EDI, [Y_INC]                      ; DI += Y_INC

    AGAIN:
    ADD EDI, [X_INC]                       ; DI += X_INC
    TEST ECX, ECX                         ; Loop Back
    JNZ SHORT THEN

    JMP SHORT DONE_LINE
  ELSE1:
  MOV ECX, [DeltaY]                        ; Loop DeltaY Times
  INC ECX
  ELSE_LOOP:
    DEC ECX
    MOV DWORD PTR [EDI], 0FFFFFFh                ; Set Color

    MOV EAX, [DeltaX]                      ; Set Error
    ADD [Error], EAX
    MOV EAX, [Error]

    CMP EAX, 0                           ; Error>0
    JLE SHORT AGAIN2
     SUB EAX, [DeltaY]                     ; Error -= DeltaY
     MOV [Error], EAX
     ADD EDI, [X_INC]                      ; DI += X_INC

    AGAIN2:
    ADD EDI, [Y_INC]                       ; DI += Y_INC
    TEST ECX, ECX                         ; Loop Back
    JNZ SHORT ELSE_LOOP
  DONE_LINE:

 RET
LINE ENDP    
    szEdit db "EDIT", 0
    
    PX1    REAL4 -30.0
    PY1    REAL4 30.0
    PZ1    REAL4 -30.0
    
    PX2    REAL4 30.0
    PY2    REAL4 30.0
    PZ2    REAL4 -30.0
    
    PX3    REAL4 -30.0
    PY3    REAL4 30.0
    PZ3    REAL4 30.0
     
    PX4    REAL4 30.0
    PY4    REAL4 30.0
    PZ4    REAL4 30.0
    
    PX5    REAL4 -30.0
    PY5    REAL4 -30.0
    PZ5    REAL4 -30.0
    
    PX6    REAL4 30.0
    PY6    REAL4 -30.0
    PZ6    REAL4 -30.0
    
    PX7    REAL4 -30.0
    PY7    REAL4 -30.0
    PZ7    REAL4 30.0
    
    PX8    REAL4 30.0
    PY8    REAL4 -30.0
    PZ8    REAL4 30.0
    
    VIEW   DWORD  256.0
    ZWORLD DWORD  300.0
    
    
    ; ANGLE_R REAL4 0.017444444444444444444444444444444
    COS_1r REAL4 0.9998476952
    SIN_1r REAL4 0.0174524064
;        2-----1
;     4/_+__3/ |
;     |  |  |  |
;     |/ 8--+--7
;     6-----5/

    ; 1, 2, 3, 4, 5, 6, 7, 8
    
    ; 1 
    ;   2 + 1
    ;   4 + 3
    ; 2 
    ;   3 + 1
    ;   6 + 4
    ; 3
    ;   4 + 1
    ;   7 + 4
    ; 4
    ;   
    ;   1  -1
    ;   4  +2 
    ;   6  +4
    ; 4
    ;   3  -1
    ;   6  +2
    
    

END START

