/***********************************************************************
 * directx.h
 *  
 *    DirectX API
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/


#ifndef __DIRECTX_H__
#define __DIRECTX_H__


typedef PVOID HDIRECTX;


typedef struct {

	HWND  hWnd;
	DWORD dwScreenHeight;
	DWORD dwScreenWidth;
	DWORD dwColorDepth;

} DIRECTXINIT, *PDIRECTXINIT;




HDIRECTX WINAPI DirectX_InitFullScreen(PDIRECTXINIT pDirectXInit);
HDIRECTX WINAPI DirectX_InitWindowMode(PDIRECTXINIT pDirectXInit);
void WINAPI DirectX_UnInit(HDIRECTX hDirectX);

PUCHAR WINAPI DirectX_BeginPaint(HDIRECTX hDirectX, PUINT pPitch);
void WINAPI DirectX_ClearVideoBuffer(HDIRECTX hDirectX);
void WINAPI DirectX_EndPaint(HDIRECTX hDirectX);
void WINAPI DirectX_BlastVideo(HDIRECTX hDirectX, PUCHAR pBuffer);

/***********************************************************************
 * The library maintains a "Virtual" Palette, so Paletting can be
 * used outside of 8-Bit Color Modes.
 *
 * However, TrueColor function is not supported in 8-bit modes.  Even though
 * we could do a "closest match" algorithm, it's not worth it.
 ***********************************************************************/
void WINAPI DirectX_SetPixelPalette(HDIRECTX hDirectX, UINT dwScreenX, UINT dwScreenY, UINT dwIndex);
void WINAPI DirectX_SetPixelTrueColor(HDIRECTX hDirectX, UINT dwScreenX, UINT dwScreenY, DWORD dwRgb);

/***********************************************************************
 * The library maintains a "Virtual" Palette, so Paletting can be
 * used outside of 8-Bit Color Modes
 ***********************************************************************/
BOOL WINAPI DirectX_FadePalette(HDIRECTX hDirectX);
BOOL WINAPI DirectX_FadeToPalette(HDIRECTX hDirectX, PALETTEENTRY *pPaletteEntries);
void WINAPI DirectX_SetPalette(HDIRECTX hDirectX, PALETTEENTRY *pPaletteEntries);
void WINAPI DirectX_GetPalette(HDIRECTX hDirectX, PALETTEENTRY *pPaletteEntries);
DWORD WINAPI DirectX_ConvertPaletteEntryToTrueColor(HDIRECTX hDirectX, PALETTEENTRY *PaletteEntry);
void WINAPI DirectX_SetPixelPaletteBuffer(HDIRECTX hDirectX, PUCHAR pBuffer, UINT dwScreenX, UINT dwScreenY, UINT dwIndex);

void WINAPI DirectX_Debug(char *pszFormatString, ...);

#endif

