/***********************************************************************
 * oglwinproc.c
 *  
 *    Window for OpenGL
 *
 *
 * Toby Opferman Copyright (c) 2004
 *
 ***********************************************************************/
 

                                                                     
#include <windows.h>

#include "oglwinproc.h"
#include "oglres.h"
#include "oglcube.h"



 /***********************************************************************
  * Internal APIs
  ***********************************************************************/
 LRESULT CALLBACK OGLWinProc_WindowProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam);
 void OGLWinProc_ProcessVirtualKeyPress(HWND hWnd, UINT vKey);
 void OGLWinProc_ProcessVirtualKeyRelease(HWND hWnd, UINT vKey);
 void OGLWinProc_CreateHandler(HWND hWnd);
 void OGLWinProc_PaintScreen(HWND hWnd);

                   
 /***********************************************************************
  * OGLWinProc_RegisterClass
  *  
  *    Registers the Test Window Proc Class
  *
  * Parameters
  *     instance Handle
  * 
  * Return Value
  *     TRUE on Success, FALSE on Failure
  *
  ***********************************************************************/
 BOOL WINAPI OGLWinProc_RegisterClass(HINSTANCE hInstance)
 {
     WNDCLASSEX WndClassEx = {0};

     WndClassEx.cbSize        = sizeof(WndClassEx);
     WndClassEx.style         = 0;
     WndClassEx.lpfnWndProc   = OGLWinProc_WindowProc;
     WndClassEx.cbWndExtra    = 0;
     WndClassEx.hInstance     = hInstance;
     WndClassEx.hIcon         = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APPLICATION));
     WndClassEx.hCursor       = LoadCursor(hInstance, IDC_ARROW);
     WndClassEx.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
     WndClassEx.lpszMenuName  = NULL;
     WndClassEx.lpszClassName = OGL_CLASS_NAME;
     WndClassEx.hIconSm       = LoadIcon(hInstance, MAKEINTRESOURCE(IDI_APPLICATION));
     
     return RegisterClassEx(&WndClassEx);
 }



 /***********************************************************************
  * OGLWinProc_CreateWindow
  *  
  *    Creates The Test Window
  *
  * Parameters
  *     instance Handle
  * 
  * Return Value
  *     Window Handle on Success, NULL on Failure
  *
  ***********************************************************************/
 HWND WINAPI OGLWinProc_CreateWindow(HINSTANCE hInstance)
 {
     HWND hWnd = NULL;

     //if(!FindWindow(OGL_CLASS_NAME, NULL))
     {
        if(hWnd = CreateWindowEx(0,OGL_CLASS_NAME, OGL_GAME_TITLE, WS_SYSMENU | WS_POPUP | WS_VISIBLE | WS_CAPTION | WS_OVERLAPPED, 0,  0, OGL_WINDOW_WIDTH, OGL_WINDOW_HEIGHT, HWND_DESKTOP, NULL,  hInstance, NULL))
        {
            ShowWindow(hWnd, SW_SHOWNORMAL);
            UpdateWindow(hWnd);
        }
     }

     return hWnd;
 }



 /***********************************************************************
  * OGLWinProc_MessageLoop
  *  
  *    Handles Window Messages to be dispatched to the Cubix Window
  *
  * Parameters
  *     instance Handle, Window Handle
  * 
  * Return Value
  *     Exit Value
  *
  ***********************************************************************/
 int WINAPI OGLWinProc_MessageLoop(HINSTANCE hInstance, HWND hWnd)
 {
     MSG Msg = {0};
     BOOL bMessageLoop = TRUE;

     while(bMessageLoop)
     {
         if(PeekMessage(&Msg, 0, 0, 0, PM_REMOVE))
         {
             if(Msg.message == WM_QUIT)
             {
                 bMessageLoop = FALSE;
             }
             else
             {
                 TranslateMessage(&Msg);
                 DispatchMessage(&Msg);
             }
        }
        else
        {
            OGLCube_Draw(hWnd);
            
        }
     }

     return Msg.wParam;
 }



 

 /***********************************************************************
  * OGLWinProc_WindowProc
  *  
  *    Handles Window Messages Send to the window
  *
  * Parameters
  *     Standard Windows Proc Handler
  * 
  * Return Value
  *     Exit Value
  *
  ***********************************************************************/
 LRESULT CALLBACK OGLWinProc_WindowProc(HWND hWnd, UINT wMsg, WPARAM wParam, LPARAM lParam)
 {
     LRESULT dwRetValue = 0;

     switch(wMsg)
     {
         case WM_CREATE:
              OGLWinProc_CreateHandler(hWnd);
              break;


         case WM_PAINT:
              OGLWinProc_PaintScreen(hWnd);
              break;

	     case WM_KEYDOWN:
              OGLWinProc_ProcessVirtualKeyPress(hWnd, wParam);
			  break;

         case WM_KEYUP:
              OGLWinProc_ProcessVirtualKeyRelease(hWnd, wParam);
              break;
            
         case WM_CLOSE:
         case WM_DESTROY:
              ShowCursor(TRUE);
              PostQuitMessage(0);
              break;

         default:
              dwRetValue = DefWindowProc(hWnd, wMsg, wParam, lParam);
     }

     return dwRetValue;
 }


 /***********************************************************************
  * OGLWinProc_PaintScreen
  *  
  *    Handles processing virtual keys
  *
  * Parameters
  *     Window Handle, Virtual Key
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
 void OGLWinProc_PaintScreen(HWND hWnd)
 {
     PAINTSTRUCT ps;

     BeginPaint(hWnd, &ps);
     EndPaint(hWnd, &ps);
 }





 /***********************************************************************
  * OGLWinProc_ProcessVirtualKeyPress
  *  
  *    Handles processing virtual keys
  *
  * Parameters
  *     Window Handle, Virtual Key
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
 void OGLWinProc_ProcessVirtualKeyPress(HWND hWnd, UINT vKey)
 {

 }

  /***********************************************************************
  * OGLWinProc_ProcessVirtualKeyPress
  *  
  *    Handles processing virtual keys
  *
  * Parameters
  *     Window Handle, Virtual Key
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
 void OGLWinProc_ProcessVirtualKeyRelease(HWND hWnd, UINT vKey)
 {
	switch(vKey)
	{
	   case VK_ESCAPE:
            DestroyWindow(hWnd);
		    break;
    }

 }


 /***********************************************************************
  * OGLWinProc_CreateHandler
  *  
  *    Handles processing virtual keys
  *
  * Parameters
  *     Window Handle, Virtual Key
  * 
  * Return Value
  *     None
  *
  ***********************************************************************/
void OGLWinProc_CreateHandler(HWND hWnd)
{
    OGLCube_Create(hWnd);
}

