/*
 * Game Header File
 *
 *
 */
#ifndef __GAME_H__
#define __GAME_H__

#include <gdi.h>

#define WM_SWITCH_GAME_STATE    WM_USER

typedef PVOID HGAME;

#define GAME_CLASS_NAME "RayCasterTest"
#define GAME_TITLE      "Toby's Raycaster Test"
#define GAME_WINDOW_WIDTH  800 + 10
#define GAME_WINDOW_HEIGHT 600 + 40

#define GAME_WIDTH  800
#define GAME_HEIGHT 600


HGAME Game_Init(HWND hWnd, HINSTANCE hInstance);
void Game_Close(HGAME hGame);
void Game_HandleKeyRelease(HGAME hGame, UINT vKey);
void Game_HandleKeyPress(HGAME hGame, UINT vKey);
void Game_HandleMenuCommands(HGAME hGame, USHORT Command, LPARAM lParam);
HDC Game_GetGameDc(HGAME hGame);
void Game_ReleaseGameDc(HGAME hGame, HDC hGameDC);
BOOL Game_MessageLoop(HGAME hGame);
void Game_DispatchMenuSelections(HGAME hGame, UINT uiMenuSelection);
BOOL Game_FadeTitleScreen(HGAME hGame);


#endif

