			/*-=-=-=-=-=-=-=-=-=-=-*
			      Toby Opferman
			    Game Source Code
			 *-=-=-=-=-=-=-=-=-=-=-*/

 /* Header Files */
 #include <conio.h>
 #include <time.h>
 #include <malloc.h>
 #include <mem.h>
 #include <stdlib.h>
 #include <dos.h>
 #include "x\vga13.h"
 #include "x\wire.h"

 /* Global Variables */
 struct star_type {
		float X, Y, Z;
		char Colour;
 } Stars[500];

 _3D_Obj *Object;
 char PlayerControl[128] = { 0 };
 void interrupt far (*OldKeyboard)(...);

 /* Set The Game Colors */
 void GamePallete(void)
{
  char R, G, B;
  int x;

  G = B = 0;
  R = 4;

 /* Loop To Set Fire Colors */
 for(x = 1; x < 36; x++)
 {
     outp(0x3C8, x);

     outp(0x3C9, R+=2);
     outp(0x3C9, G);
     outp(0x3C9, B);

     G = x % 2 ? G++ : G;
     B = x % 2 ? B : B++;
 }
     /* Manually Set The Star Colours */
     outp(0x3C8, 36);
     outp(0x3C9, 15);
     outp(0x3C9, 15);
     outp(0x3C9, 15);

     outp(0x3C8, 37);
     outp(0x3C9, 30);
     outp(0x3C9, 30);
     outp(0x3C9, 30);

     outp(0x3C8, 38);
     outp(0x3C9, 63);
     outp(0x3C9, 63);
     outp(0x3C9, 63);


  /* Set Some Blues */
  R = 10;
  G = 10;
  B = 15;

 /* Loop To Set Colors */
 for(x = 50; x < 75; x++)
 {
     outp(0x3C8, x);

     outp(0x3C9, R);
     outp(0x3C9, G);
     outp(0x3C9, B++);

     G = x % 2 ? G++ : G;
     R = x % 2 ? R : R++;
 }


}

 /* Play Game Loop */
 void PlayGame(void)
{
  void (*BackGround)(char far *);
  int Done = 0;
  int LevelCounter = 0;
  long Score = 0, X;

  /* Seed Random Numbers */
  srand((int)time(0));

  /* Initialize Stars For Background Effects */
  for(X = 0; X < 500; X++)
  {
     Stars[X].Colour = (rand()%3) + 36;
     Stars[X].X = rand()%320;
     Stars[X].Y = rand()%160;
     Stars[X].Z = rand()%256;
  }

  /* Clear Keys */
  for(X = 0; X < 128; X++)
   PlayerControl[X] = 0;

  while(kbhit())
    getch();

  /* Hook Keyboard Interrupt */
  OldKeyboard = getvect(0x9);
  setvect(0x9, KeyBoardInt);

  /* Fade Out Menu Screen */
  VRetrace();
  while(!FadeOut())
  {
    delay(10);
    VRetrace();
  }

  /* Reset Pallete */
  GFXMode();

  /* Set Game Pallete */
  GamePallete();

  /* Loop Until Lose, Quit Or Win Game */
  while(!Done && LevelCounter < 5)
  {
    /* Get Background Creator Function Pointer */
    BackGround = (void (*)(char far *))Level(LevelCounter);

    /* Run The Game */
    RunGame(&Score, BackGround, LevelCounter, &Done);

    /* Next Level */
    LevelCounter++;
  }

  /* Reset KeyBoard Int */
  setvect(0x9, OldKeyboard);

  /* Clear Keys */
  while(kbhit())
    getch();

   /* Check If Win, Quit Or Lose */
  if(LevelCounter == 5 && (!Done))
      WinnerScreen(Score);
   else if(Done == 1)
      LoserScreen(Score);
}

 /* Display Winning Screen */
 void WinnerScreen(long Score)
{
  FILE *F;
  char String[10];
  RGB Rgb[256];

  /* Open Winner Picture */
  F = fopen("WINNER.PIC", "rb");

  if(!F)
    ERROR(2);

  /* Zero Pallete & Load PCX File */
  ZeroRGB();
  LoadPCX(Rgb, F);

  /* Set A Bright White */
  Rgb[255].R = 63;
  Rgb[255].G = 63;
  Rgb[255].B = 63;


  /* Write Score to Screen */
  ltoa(Score, String, 10);
  Write_To_Screen(10, 170, 255, (char far *)0xA0000000, String, 2, 0);

  fclose(F);

  /* Fade In */
  VRetrace();
  while(!FadeIn1(Rgb))
  {
     delay(10);
     VRetrace();
  }

  /* Wait for KeyPress (ESC) */
  while(getch() != 27);

  /* Fade Out */
  VRetrace();
  while(!FadeOut())
  {
     delay(10);
     VRetrace();
  }

}

 /* Display Losing Screen */
 void LoserScreen(long Score)
{
  FILE *F;
  char String[10];
  RGB Rgb[256];

  /* Open Losing Picture */
  F = fopen("LOSER.PIC", "rb");

  if(!F)
    ERROR(2);


  /* Zero pallete & Load Picture */
  ZeroRGB();

  LoadPCX(Rgb, F);

  /* Set A Bright White */
  Rgb[255].R = 63;
  Rgb[255].G = 63;
  Rgb[255].B = 63;

  /* Write Score on the Screen */
  ltoa(Score, String, 10);
  Write_To_Screen(10, 140, 255, (char far *)0xA0000000, String, 2, 0);

  fclose(F);

  /* Fade In */
  VRetrace();
  while(!FadeIn1(Rgb))
  {
     delay(10);
     VRetrace();
  }

  /* Wait for Keypress (ESC)*/
  while(getch() != 27);

  /* Fade Out */
  VRetrace();
  while(!FadeOut())
  {
     delay(10);
     VRetrace();
  }

}

 /* Allocate Far Memory */
 char far * Memory(unsigned int Amount)
{
  char far *X;

  /* Allocate Memory */
  X = (char far *)farmalloc(Amount);

  /* If Out Of Memory, ERROR */
  if(!X)
  {
    /* Reset KeyBoard Int */
    setvect(0x9, OldKeyboard);

    ERROR(0);
  }

  /* Preset Memory To Zero */
  _fmemset(X, 0, Amount);

  /* Return Memory */
  return X;
}


 /* RunTime Loop Of Game */
 void RunGame(long *Score, void (*BKGG)(char far *), int GameLevel, int *Status)
{
  char far *BackGroundBuffer, far *Screen;
  SPRITE Aliens[30], Man, Missiles[10]; /* Aliens Get 6 Missiles at a Time */
  int AlienCount = 30;		       /* Humans Get 4 Missiles at a Time */
  int Lives = 3;
  int BackGroundToggle = 1;
  char String2[10] = { "LEVEL  " };

  /* Allocate Screen Buffers */
  Screen = Memory(64000);

  /* Set Up BackGround Buffer */
  BackGroundBuffer = Memory(64000);

  itoa(GameLevel + 1, String2 + 6, 10);
  Write_To_Screen(125, 175, 1, Screen, String2, 3, 0);

  /* Display To Video Screen */
  VRetrace();
  _fmemcpy((char far *)0xA0000000, Screen, 64000);

  /* Setup Players & Aliens */
  Setup(Aliens, &Man, Missiles, GameLevel);

  /* Loop While Not Dead, Not Quit or Not Win Level */
  while(AlienCount && Lives && (!(*Status)))
  {
    /* Do Background */
    if(BackGroundToggle) /* Caps Lock Turns Off BackGround */
      BKGG(BackGroundBuffer);


    if(PlayerControl[58]) /* Toggle BackGround? */
      BackGroundToggle = 0;

    if(PlayerControl[15])
      BackGroundToggle = 1;

    /* Do The Calculations */
   DoIt(Aliens, &Man, Missiles, Score, &Lives, &AlienCount, GameLevel, Status);

    /* Paste Background */
    _fmemcpy(Screen, BackGroundBuffer, 171*320);

    /* Paste Foreground */
    Put(Aliens, &Man, Missiles, *Score, Lives, Screen, GameLevel, Status);

    /* Display To Video Screen */
    VRetrace();
    _fmemcpy((char far *)0xA0000000, Screen, 171*320);
  }

  /* Ran Out Of Lives, You Lose */
  if(Lives <= 0)
    *Status = 1;

  /* Bonus Lives Points */
  *Score += Lives*100;

  // Temps
  if(kbhit())
     getch();

  /* Free Memory */
  if(GameLevel == 3)
      Dealloc3D();

  farfree(Screen);
  farfree(BackGroundBuffer);
  FREE(Aliens, &Man, Missiles);
}

 /* Free Allocated Memory */
 void FREE(SPRITE *A, SPRITE *H, SPRITE *M)
{
  int Count;

  /* Free Human Player */
  farfree(H->Bkg);

  /* Free Alien Memory */
  for(Count = 0; Count < 30; Count++)
      farfree(A[Count].Bkg);

  /* Free Missiles */
  for(Count = 0; Count < 10; Count++)
     farfree(M[Count].Bkg);


}

 /* Setup Game */
 void Setup(SPRITE *A, SPRITE *H, SPRITE *M, int CurLevel)
{
   /* GFX Images */
   char Man[] = { 000, 000, 000, 000,  38,  38, 000, 000, 000, 000,
		  000, 000, 000,  38,  37,  37,  38, 000, 000, 000,
		  000, 000,  38,  37,  37,  37,  37,  38, 000, 000,
		  000, 000,  38,  37,  37,  37,  37,  38, 000, 000,
		  000,  38,  37,  37,  38,  38,  37,  37,  38, 000,
		   38,  38,  38,  38,  38,  38,  38,  38,  38,  38  } ;

   char Alien1[] = { 000, 000, 000,  36,  36,  36,  36, 000, 000, 000,
		     000,  36,  36,  55,  57,  55,  55,  36,  36, 000,
		      36,  58,  55,  57,  56,  56,  57,  55,  58,  36,
		      36,  58,  55,  57,  56,  56,  57,  55,  58,  36,
		     000,  36,  36,  55,  55,  57,  55,  36,  36, 000,
		     000, 000, 000,  36,  36,  36,  36, 000, 000, 000 } ;

   char Alien2[] = { 000, 000,  37,  38, 38, 38,  38,  37, 000, 000,
		     000, 000, 000, 000, 60, 60, 000, 000, 000, 000,
		     000, 000, 000,  70, 60, 60,  70, 000, 000, 000,
		     000, 000,  70, 000, 60, 60, 000,  70, 000, 000,
		     000,  70,  70, 000, 60, 60, 000,  70,  70, 000,
		      74, 000,  74, 000, 74, 74, 000,  74, 000,  74 } ;

   char Alien3[] = {  37, 000, 000,  37, 00, 00,  37, 000, 000,  37,
		     000,  65,  65, 000, 38, 38, 000,  65,  65, 000,
		     000, 000, 000,  65, 38, 38,  65, 000, 000, 000,
		     000, 000,  65,  65, 38, 38,  65,  65, 000, 000,
		     000,  65, 000, 000, 38, 38, 000, 000,  65, 000,
		      37, 000, 000,  37, 00, 00,  37, 000, 000,  37 } ;

   char Alien4[] = { 000,  50,  51,  52, 53, 54,  55,  56,  57, 000,
		     000, 000, 000, 000, 37, 37, 000, 000, 000,  00,
		     000, 000, 000, 000, 37, 37, 000, 000, 000,  00,
		     000, 000, 000,  37, 10, 10,  37, 000, 000,  00,
		     000, 000,  37, 100, 10, 10, 100,  37, 000,  00,
		     000, 000,  54,  55, 54, 53,  52,  51,  00,  00 } ;

   char HumanMissile[] = { 000, 38, 38, 000,
			    38, 38, 38, 38,
			    38, 38, 38, 38,
			   000, 38, 38, 000 } ;

   char AlienMissile[] = { 000, 25, 25, 000,
			    25, 25, 25, 25,
			    25, 25, 25, 25,
			   000, 25, 25, 000 } ;

   char *Temp;
   int Count, Count2, Count3;

   /* Create Human Ship */

   /* Allocate Memory */
   H->Bkg = Memory(60);


   /* Setup Player Variable Values */

    /* Only 1 Frame Image */
   H->MaxFrames = 1;
    /* Current Frame is Always 0 */
   H->CurFrame = 0;
    /* Counter is Always 0 */
   H->Counter = 0;
    /* The Velocity of Y is Always 0, Velocity of X is 0 */
   H->VelX = H->VelY = 0;
    /* These Are always 0 (Unused) */
   H->NewX = H->NewY = 0;
    /* Current Position */
   H->X =  150; H->Y = 164;
    /* Image Size */
   H->MaxX = 10; H->MaxY = 6;

   /* Paste Human Ship Image */
   for(Count = 0; Count < 60; Count++)
     H->Bkg[Count] = Man[Count];

   /* Special Counter to Calculate Alien Coloumn Position */
   Count3 = 0;

   /* Create 30 Aliens */
   for(Count = 0; Count < 30; Count++)
   {
     /* Set Up Commons */

      /* Only 1 Frame Image */
      A[Count].MaxFrames = 1;

      /* Current Frame is always 0 */
     A[Count].CurFrame = 0;

      /* Counter (Used in this case as a Delay Before Alien Moves) */
     A[Count].Counter = 0;

      /* Unused (Set To 0) */
     A[Count].VelX = A[Count].VelY = 0;
     A[Count].NewX = A[Count].NewY = 0;
     A[Count].NCountF = 0;


     /* Object Dimentions */
     A[Count].MaxX = 10;
     A[Count].MaxY = 6;

     /* Calculate Begining Alien Position */
     A[Count].X = Count3*20 + 50;
     A[Count].Y = (Count < 10 ? 50 : (Count < 20 ? 70 : 90)) + CurLevel*5;

      /* A is used as a Live Counter, if A = 1 Then the Alien is dead */
     A[Count].A = 0;

      /* B is used as a Direction, 0 for Left, 1 for right */
     A[Count].B = 1;

     /* Increment The Column Position Counter */
     Count3 ++;

     /* If 10, Start over */
     if(Count3 >= 10)
       Count3 = 0;

     /* Rand Select Alien */
     switch(rand()%4)
     {
	case 0 : Temp = Alien1;
	break;
	case 1 : Temp = Alien2;
	break;
	case 2 : Temp = Alien3;
	break;
	case 3 : Temp = Alien4;
     }

     /* Allocate Memory */
     A[Count].Bkg = Memory(60);


     /* Paste Alien Image */
     for(Count2 = 0; Count2 < 60; Count2++)
       A[Count].Bkg[Count2] = Temp[Count2];

   }

   /* Create Missiles */
   for(Count = 0; Count < 10; Count++)
   {
       /* A = 1, Missile Active */
       M[Count].A = 0;

       /* Allocate Memory */
       M[Count].Bkg = Memory(16);

	/* Alien or Human Missile */
       Temp = Count < 6 ? AlienMissile : HumanMissile;

       /* Paste Missile Image */
       for(Count2 = 0; Count2 < 16; Count2++)
	  M[Count].Bkg[Count2] = Temp[Count2];

	  /* Set Up Commons */
	   /* Only 1 Frame Image */
	  M[Count].MaxFrames = 1;

	  /* Current Frame is always 0 */
	  M[Count].CurFrame = 0;
	  /* Counter (Not Used) */
	  M[Count].Counter = 0;

	  /* Unused (Set To 0) */
	  M[Count].VelX = A[Count].VelY = 0;
	  M[Count].NewX = A[Count].NewY = 0;
	  M[Count].NCountF = 0;

	  /* Object Dimentions */
	  M[Count].MaxX = 4;
	  M[Count].MaxY = 4;
	  /* Created When Fired */
	  M[Count].X = 0;
	  M[Count].Y = 0;

     }

}

 /* Artifical Intelligence & Object Movements */
 void DoIt(SPRITE *A, SPRITE *H, SPRITE *M, long *Score, int *Lives, int *Aliens, int GLevel,
	   int *Status)
{
  int Count, Count2, Count3;

  /* Aliens Fire Missiles */
  if(GLevel > 1) /* Aliens Don't Fire until Level 3 */
  {
    /* At Odd Levels Random Fire */
    if (GLevel & 1)
    {
       for (Count = 0; Count < 30; Count++)
       {
	  if(A[Count].A) /* Alien Alive? */
	    continue;

	  if(((rand() % 310)+1)/(Count+1) == 10) /* Fire Missile */
	  {
	     /* Find Available Missile */
	     for(Count2 = 0; Count2 < 6; Count2++)
	     {
	       /* Missile Available? */
	       if(M[Count2].A)
		 continue;

	       /* Activate & Launch */
	       M[Count2].A = 1;
	       M[Count2].X = A[Count].X + 3;
	       M[Count2].Y = A[Count].Y + 10;

	       /* Exit Loop */
	       break;
	     }
	   }
       }
    }
    else /* Level 4 + Smarter Fire */
    {
       for (Count = 0; Count < 30; Count++)
       {
	  if(A[Count].A) /* Alien Alive? */
	    continue;

	  /* Calculate Human X */
	  Count3 = A[Count].X + 3 - H->X;
	  /* Decide To Fire */
	  if((Count3 < 11 && Count3 > -5) && (rand()%2))
	  {
	     /* Find Available Missile */
	     for(Count2 = 0; Count2 < 6; Count2++)
	     {
	       /* Missile Available? */
	       if(M[Count2].A)
		continue;
	       /* Activate & Launch */
	       M[Count2].A = 1;
	       M[Count2].X = A[Count].X + 3;
	       M[Count2].Y = A[Count].Y + 10;

	       /* Exit Loop */
	       break;
	     }
	  }
       }
    }
  }
  /* Human Actions */

   /* Player Quits */
  if(PlayerControl[1])
    *Status = 3;

  /* Player Fires */
  if(PlayerControl[57])
  {
     /* Find Available Missile */
     for(Count = 6; Count < 10; Count++)
     {
       /* Missile Available? */
       if(M[Count].A)
	continue;

       /* Activate & Launch */
       M[Count].A = 1;
       M[Count].X = H->X + 3;
       M[Count].Y = H->Y - 4;

       /* Exit Loop */
       break;
     }
  }

  /* Player Moves */
  if(!PlayerControl[75] || !PlayerControl[77])
    if(PlayerControl[75])
      H->X -= 2;
    else if(PlayerControl[77])
	    H->X += 2;

  /* Define Outside Boundries */
  if(H->X < 10)
    H->X = 10;

  /* Define Outside Boundries */
  if(H->X > 300)
    H->X = 300;


  /* Detect Missile Hits */
  for(Count = 0; Count < 10; Count++)
 {
    /* Is Missile Active? */
    if(M[Count].A)
     if(Count < 6)  /* Human or Alien Missiles */
     {
       /* Calculate if in X range */
       Count2 = M[Count].X - H->X;
       if(Count2 > -4 && Count2 < 10)
       {
	 /* Calculate if in Y range */
	 Count2 = M[Count].Y - H->Y;
	 if(Count2 < 6 && Count2 > -4)
	 {
	   /* Lose 1 Live */
	   (*Lives)--;

	   /* Missile Deactive */
	   M[Count].A = 0;
	 }
       }
     }
     else
     {
       /* Check All Aliens */
       for(Count3 = 0; Count3 < 30; Count3++)
       {
	 /* Is Alien Alive ? */
	 if(A[Count3].A)
	   continue;

	 /* Calculate if in X range */
	 Count2 = M[Count].X - A[Count3].X;

	 if(Count2 < 10 && Count2 > -4)
	 {
	   /* Calculate if in Y range */
	   Count2 = M[Count].Y - A[Count3].Y;
	   if(Count2 > -4  && Count2 < 6)
	   {
	     /* Alien Dies */
	     A[Count3].A = 1;

	     (*Aliens)--;

	     /* Calculate Player Score */
	     *Score+= (400 - (A[Count3].Y*2)) + (GLevel*10);

	     /* Missile Deactive */
	     M[Count].A = 0;
	   }
	 }
       }
     }

     /* Move Missiles */
      if(M[Count].A)
     {
       /* Calculate Next Location */
       M[Count].Y = Count < 6 ? M[Count].Y + 3 : M[Count].Y - 3;

       /* Check For Deactivation */
       if(M[Count].Y + 4 >= 170 || M[Count].Y <= 50)
	  M[Count].A = 0;
      }
  }

}

  /* Paste Images on Screen Buffer */
  void Put(SPRITE *A, SPRITE *H, SPRITE *M, long Score, int Lives, char far *Buffer, int LevelC, int *Status)
{
   char String[10];
   int Count;

   /* Paste Score */
   ltoa(Score, String, 10);
   Write_To_Screen(10, 10, 1, Buffer, String, 2, 0);

   /* Paste Lives */
   strcpy(String, "L  ");
   itoa(Lives, String + 2, 10);
   Write_To_Screen(260, 10, 1, Buffer, String, 2, 0);


   /* Paste Images */
   PutImage(H->Bkg, H, Buffer, 1);

   /* Put Aliens */
   for(Count = 0; Count < 30; Count++)
   {

     /* If Alien is Dead, Continue */
     if(A[Count].A)
       continue;

     /* Increment Movement Delay */
     A[Count].Counter++;

     /* Is Alien ready to Move ? */
     if(A[Count].Counter > (7 - (LevelC == 1 ? 3 : LevelC)) )
     {

       /* Reset Counter */
       A[Count].Counter = 0;

       /* Check Direction */
       if (A[Count].B)
	   A[Count].X += 3;
       else
	   A[Count].X -= 3;

       /* Alien Ready To switch Direction ? */
       if(A[Count].X > 300)
       {
	 A[Count].B = 0;
	 A[Count].Y+= 7;
       }

       /* Alien Ready To switch Direction ? */
      if(A[Count].X < 10)
      {
	A[Count].B = 1;
	A[Count].Y+= 7;
      }

      /* Aliens Landed ? */
      if(A[Count].Y + A[Count].MaxY >= 164)
	*Status = 1;

     }

     /* Paste Image */
     PutImage(A[Count].Bkg, &A[Count], Buffer, 1);
   }

   for(Count = 0; Count < 10; Count++)
   {
      /* Missile Active ? */
      if(!M[Count].A)
	continue;

      /* Put Missile On Screen */
      PutImage(M[Count].Bkg, &M[Count], Buffer, 1);
   }

}

 /* Get Background Functions */
 void * Level(int LevelC)
{
  switch(LevelC)
  {
     case 0 :  return (void *)BK1;
     case 1 :  return (void *)BK2;
     case 2 :  return (void *)BK3;
     case 3 :  Setup3D();
     return (void *)BK4;
     case 4 :  return (void *)BK5;
  }

  return NULL;
}

 /* Back Ground #1, Fire */
 void BK1(char far *X)
{
  unsigned int Count;

  /* Randomly Fill Bottom Row */
  for(Count = 0; Count < 320; Count++)
    X[(170*320)+Count] = (rand() % 25) + 10;

  Count = 150 * 320;

  /* Loop Through Fire Window */
  while(Count < (unsigned int)170*320)
  {
      /* Calculate Fire Colour Pixel */
      X[Count] = (X[Count + 320] +
		       X[Count + 321] +
		       X[Count + 319] +
		       X[Count + 640]) >>2;

      /* If Not Zero, Subtract 1 */
      if(X[Count])
	 (X[Count])--;

      /* Next Pixel */
      Count++;
  }
}

 /* BackGround #2, StarField */
 void BK2(char far *X)
{
 int Count;

 /* Clear Buffer */
 _fmemset(X, 0, 171*320);

 /* Do Stars */
 for(Count = 0; Count < 500; Count++)
 {
    /* Increment Speed depending ON star colour */
    switch(Stars[Count].Colour)
    {
	case 36 : Stars[Count].Y += 2;
	break;
	case 37 : Stars[Count].Y += 3;
	break;
	case 38 : Stars[Count].Y += 4;
	break;
	default: /* Get Correct Colour */
	 Stars[Count].Colour = (rand()%3) + 36;
    }

    /* Check X Out of Bounds */
    if(Stars[Count].X <= 0 || Stars[Count].X > 320)
      Stars[Count].X = (rand() % 320) + 1;

    /* Check Y Out Of Bounds */
    if(Stars[Count].Y < 0 || Stars[Count].Y > 170)
      Stars[Count].Y = rand() % 160;

    *(X + (int)Stars[Count].X + ((int)Stars[Count].Y*320)) = Stars[Count].Colour;
   }
}

 /* Deallocate 3D */
 void Dealloc3D(void)
{
  free(Object->P);
  free(Object->LinePairs);
  free(Object);
}

 /* Set Up 3D Object For Back Ground #4 */
 void Setup3D(void)
{
    FILE *WiREFiLE;
    int Counta;

    /* Allocate Object */
    Object = (_3D_Obj *)malloc(sizeof(_3D_Obj));

    if(!Object)
    {
       setvect(0x9, OldKeyboard);

       ERROR(0);
    }

    /* Open Object File*/
    WiREFiLE = fopen("OBJECT.DAT", "rt");

    if(!WiREFiLE)
    {
       /* Set KeyBoard Int */
       setvect(0x9, OldKeyboard);

       ERROR(2);
    }

    /* Read In Object Data */
    fscanf(WiREFiLE, "%i %i %f", &Object->Points, &Object->MaxLines, &Object->Radians);
    fscanf(WiREFiLE, "%i %i %i", &Object->OffSets.x, &Object->OffSets.y, &Object->OffSets.z);
    fscanf(WiREFiLE, "%i", &Object->Colour);

    /* Convert Degress to Radians */
    Object->Radians = Rad(Object->Radians);

    /* Allocate Points */
    Object->P =(_3D_Point *)malloc(sizeof(_3D_Point)*Object->Points);

    if(!Object->P)
    {
       /* Set KeyBoard Int */
       setvect(0x9, OldKeyboard);

       ERROR(0);
    }

    /* Allocate Lines */
    Object->LinePairs = (int *)malloc(sizeof(int)*Object->MaxLines*2);

    if(!Object->LinePairs)
    {
       /* Set KeyBoard Int */
       setvect(0x9, OldKeyboard);

       ERROR(0);
    }

    Counta = Object->Points;

    /* Get Points */
    while(Counta)
    {
	Counta--;

	fscanf(WiREFiLE, "%f %f %f", &Object->P[Counta].x,
				     &Object->P[Counta].y,
				     &Object->P[Counta].z) ;
    }

    Counta = Object->MaxLines*2;

    /* Get Lines */
    while(Counta)
    {
	Counta--;
	fscanf(WiREFiLE, "%i", &Object->LinePairs[Counta]);

	Counta--;
	fscanf(WiREFiLE, "%i", &Object->LinePairs[Counta]);
    }

    fclose(WiREFiLE);
}


 /* BackGround #3, Another Star Field */
 void BK3(char far *X)
{
 int Count, X2, Y;

 /* Clear Buffer */
 _fmemset(X, 0, 171*320);

 /* Do Stars */
 for (Count = 0; Count < 500; Count++)
 {
    /* Increment Speed depending ON star colour */
    switch(Stars[Count].Colour)
    {
	case 36 : Stars[Count].Z += 2;
	break;
	case 37 : Stars[Count].Z += 3;
	break;
	case 38 : Stars[Count].Z += 4;
	break;
	default: /* Get Correct Colour */
	 Stars[Count].Colour = (rand()%3) + 36;
    }
    /* Check if Z > 256 */
    if(Stars[Count].Z >= 256)
    {
       /* Reseed Stars */
       Stars[Count].Z = (rand()%256) - 128;
       Stars[Count].X = (rand()%320) - 160;
       Stars[Count].Y = (rand()%170) - 85;
    }
    /* Z = 0? Z = 1, Protection from Divide by 0 */
    if(!Stars[Count].Z)
      Stars[Count].Z = -1;

    /* Calculate X, Y offsets */
    X2 =  ((Stars[Count].X*256.0) / Stars[Count].Z) + 160;
    Y =  ((Stars[Count].Y*256.0) / Stars[Count].Z) + 100;

    /* Check X Out of Bounds */
    if((X2 >= 0 && X2 < 320) && (Y >= 0 && Y <= 170))
      X[X2 + (Y*320)] = Stars[Count].Colour;

   }

}


 /* BackGround #4, 3D */
 void BK4(char far *X)
{
  _fmemset(X, 0, 64000);

  /* Rotate Object */
  switch(rand()%3)
  {
     case 0 : ObjRotX(Object);
     break;
     case 1 : ObjRotY(Object);
     break;
     case 2 : ObjRotZ(Object);
     break;
  }

  /* Draw Object */
  ObjDraw(Object, X);
}


 /* BackGround #5 Dual Fire */
 void BK5(char far *X)
{
  unsigned int Count;
  /* Bottom Fire */
  BK1(X);

  /* Randomly Fill Top Row */
  for(Count = 0; Count < 320; Count++)
    X[(50*320)+Count] = (rand() % 25) + 10;

  Count = 70 * 320;

  /* Loop Through Fire Window */
  while(Count > (unsigned int)50*320)
  {
      /* Calculate Fire Colour Pixel */
      X[Count] = (X[Count - 320] +
		       X[Count - 321] +
		       X[Count - 319] +
		       X[Count - 640]) >>2;

      /* If Not Zero, Subtract 1 */
      if(X[Count])
	 (X[Count])--;

      /* Next Pixel */
      Count--;
  }

}


 /* Load PCX Picture File */
 void LoadPCX(RGB *Rgb, FILE *X)
{
 unsigned char far *Video = (char far *)0xA0000000;
 unsigned char Char1, Char2;
 unsigned int Counter;

  /* Skip PCX Header */
  fseek(X, 128, SEEK_SET);

  Counter = 0;

  /* Plot Picture On Screen */
  while(Counter < 64000)
  {
     /* Get Pixel */
     Char1 =(unsigned char) fgetc(X);

     /* Uncode RLE Coding */
     if(Char1 >= 192)
     {
       Char1-= 192;
       Char2 = (unsigned char) fgetc(X);

       while(Char1--)
	Video[Counter++] = Char2;
     }
     else
	Video[Counter++] = Char1;
  }

  fseek(X, -768, SEEK_END);

  /* Save Pallete */
  for(Counter = 0; Counter < 256; Counter++)
  {
     Rgb[Counter].R = (fgetc(X)>>2);
     Rgb[Counter].G = (fgetc(X)>>2);
     Rgb[Counter].B = (fgetc(X)>>2);
  }
}

 /* Hook The Keyboard To Handle Fast Input */
 void interrupt far  KeyBoardInt(...)
{
  int Temp;

  /* Get Keystroke & Tell PIC It has been handled */
  asm {
       STI
       IN AL, 0x60
       XOR AH, AH
       MOV Temp, AX
       IN AL, 0x61
       OR AL, 0x82
       OUT 0x61, AL
       AND AL, 0x7F
       OUT 0x61, AL
       MOV AL, 0x20
       OUT 0x20, AL
  }

  /* Was Button Pressed or Released */
  if(Temp < 128) /* Button Pressed */
    PlayerControl[Temp] = 1;
  else /* Button Released */
    PlayerControl[Temp - 128] = 0;

}