		  /*-=-=-=-=-=-=-=-=-=-=-=-=-*
		    T O B Y   O P F E R M A N
			 Space Invaders
			   (C)1997
		   *-=-=-=-=-=-=-=-=-=-=-=-=-*/


 /* Header Files */
 #include <stdio.h>
 #include <conio.h>
 #include <stdlib.h>
 #include <dos.h>
 #include <mem.h>
 #include <malloc.h>
 #include <string.h>
 #include <time.h>
 #include "x\mouse.h"
 #include "x\vga13.h"
 #include "x\game.h"

 /* Prototypes */
 void Intro(void);
 void Extro(void);
 void Game(void);
 void Instructions(void);
 void Title(char *);
 char Menu(void);
 void Plot(int, int, char *);
 void CreateMenu(void);
 void Instructions(void);
 void DrawBox(void);


 /* Main Module */
 int main(void)
{
  Intro();
  Game();
  Extro();

  return 0;
}

 /* IntroDuction & Setup */
 void Intro(void)
{
  /* Display Information & Delay */
  printf(" S P A C E   I N V A D E R S\n");
  printf("     by Toby Opferman (c) 1997\n");
  delay(1000);

  /* Fade Out Of Text Mode */
  VRetrace();

  while(!FadeOut())
  {
    delay(10);
    VRetrace();
  }

  /* Switch To Graphics Mode */
  GFXMode();
}

 /* Exit */
 void Extro(void)
{
  RGB Rgb[256];
  char *Message[] = { "-=-=-=-=-=-=-=- SPACE INVADERS -=-=-=-=-=-=-=-",
		       "                   CREDITS",
		       "                Toby Opferman",
		       "           http://www.opferman.com",
		       "              toby@opferman.com",
		       "                  _Secret",
		       "                  (c)1997" } ;
  int x;

  /* Switch To Text Mode */
  TextMode();
  /* Grab RGB Pallete */
  GetRGB(Rgb);
  /* NULL Pallete */
  ZeroRGB();

  DrawBox();

  /* Plot Messages On The Screen */
  for(x = 0; x < 7; x++)
    Plot(x*3 + 3, strlen(Message[x]), Message[x]);

  /* Set Cursor At bottom of Screen */
  gotoxy(5,23);

  /* Fade Into Text Mode */
  VRetrace();

  while(!FadeIn1(Rgb))
  {
    delay(10);
    VRetrace();
  }

  /* Delay */
  delay(1000);
}

 void DrawBox(void)
{
  /* Draw Box */
  asm {
	MOV AX, 0xB800
	MOV ES, AX
	MOV AH, 0x09
	MOV AL, 177
	MOV CX, 2000
	XOR DI, DI
	REP STOSW
	MOV DI, (2*160) + (3*2)
	MOV AX, 0x4F00
	MOV BX, 20
  }
  LOOP_HERE:
  asm {
	MOV CX, 70
	REP STOSW
	CMP BX, 19
	JA SHORT N
	MOV WORD PTR ES:[DI], 0
  }
  N:
  asm {
	ADD DI, 20
	DEC BX
	JNZ SHORT LOOP_HERE
	ADD DI, 2
	XOR AX, AX
	MOV CX, 70
	REP STOSW
  }
}

 /* Plot Message On Text Screen */
 void Plot(int Y, int Len, char *X)
{

  Y*=160;

  asm {
	MOV AX, 0xB800
	MOV ES, AX
	MOV DI, Y
	ADD DI, 14*2
	MOV SI, X
	MOV CX, Len
  }
  P:
  asm {
	MOVSB
	INC DI
	LOOP SHORT P
  }
}

 /* Game Loop */
 void Game(void)
{
  int Quit = 0;


   Title("TITLE.PIC");
   do {
	srand((int)time(0));

	switch(Menu())
	{
	  case 0 : PlayGame();
	   break;
	  case 1 : Instructions();
	   break;
	  case 2 : Quit = 1;
	   break;
	  case 3 :
	   /* Fade Out */
	   VRetrace();

	   while(!FadeOut())
	   {
	     delay(10);
	     VRetrace();
	   }
	   Title("AUTHOR.PIC");
	}
   } while(!Quit) ;

   /* Fade Out */
   VRetrace();

   while(!FadeOut())
   {
     delay(10);
     VRetrace();
   }
}

 /* Display Instructions */
 void Instructions(void)
{
  int x;
  char *Message[] = {
    "                 INSTRUCTIONS",
    " ", " ", " ", " ",
    "   This is a five level arcade-style game based on the",
    "old Space Invaders Game.  It is a smaller version but",
    "a bit simular.  If you beat all five levels you win.",
    "Object is to destroy all the aliens before they land.",
    "If they land, no matter how many lives you have left,",
    "You have automatically lost the game.  Each Round You",
    "Start off with 3 Lives",
    "KEYS:  RIGHT ARROW /  LEFT ARROW / ESCAPE (Quits) ",
    "SPACEBAR (Shoots) ",
    "CAPSLOCK & TAB (off/on BackGround Effect)",
    "100 Points Bonus Each Live left At end of Turn" };

  TextMode();
  DrawBox();

  for(x = 0; x < 16; x++)
    Plot(x + 3, strlen(Message[x]), Message[x]);

  getch();
  GFXMode();
}


 /* Display Title Screen */
 void Title(char *Name)
{
  RGB Rgb[256];
  FILE *X = fopen(Name, "rb");

  /* If File Error, Display Error Message */
  if(!X)
    ERROR(2);

  /* Zero Pallete */
  ZeroRGB();

  LoadPCX(Rgb, X);

  fclose(X);

  /* Fade Screen In */
  VRetrace();

  while(!FadeIn1(Rgb))
  {
    delay(10);
    VRetrace();
  }

  /* Wait For KeyPress */
  getch();

  /* Fade Out */
  VRetrace();

  while(!FadeOut())
  {
    delay(10);
    VRetrace();
  }
}


 /* Display Menu */
 char Menu(void)
{
 char Choice = -1;
 int X, Y;

 /* Check Mouse Error */
 if(!ResetMouse())
   ERROR(1);

 /* RESET Graphics Mode To Restore Default Colour Pallete */
 GFXMode();

 /* Create The Menu */
 CreateMenu();

 /* Display Mouse Pointer */
 ShowMouse();

 /* Loop Until Selection */
 do {

   /* Mouse Button Pressed */
   if(GetMouseButton())
   {
     X = GetMouseX();
     Y = GetMouseY();

     /* Play Game */
     if(X >= 110 && X <= 210)
       if(Y >= 60 && Y <= 78)
	  Choice = 0;

     /* Instructions */
     if(X >= 100 && X <= 220)
       if(Y >= 90 && Y <= 108)
	  Choice = 1;

     /* Quit */
     if(X >= 140 && X <= 180)
       if(Y >= 120 && Y <= 138)
	  Choice = 2;

     /* Author */
     if(X >= 50 && X <= 180)
       if(Y >= 160 && Y <= 192)
	  Choice = 3;

   }

   /* Key Pressed */
   if(kbhit())
   {
       switch(getch())
       {
	   /* Quit */
	   case 'Q' :
	   case 'q' :
	     Choice = 2;
	     break;

	   /* Play */
	   case 'P' :
	   case 'p' :
	     Choice = 0;
	     break;

	   /* Instructions */
	   case 'I' :
	   case 'i' :
	     Choice = 1;
	     break;

	   /* Toby */
	   case 'T' :
	   case 't' :
	     Choice = 3;
	     break;
	}
   }

 } while(Choice == -1) ;

 /* Hide Mouse */
 HideMouse();

 /* Return Choice */
 return Choice;
}

 /* Create The Menu */
 void CreateMenu(void)
{
 unsigned int x, y;
 char R, G, B, far *Video = (char far *)0xA0000000;
 RGB Rgb[256];

 R = G = B = 15;

 /* Set BackGround Colors */
 for(x = 1; x < 21; x++)
 {
     outp(0x3C8, x);

     outp(0x3C9, R+=2);
     outp(0x3C9, G+=2);
     outp(0x3C9, B+=2);
 }

 /* Grab Pallete */
 GetRGB(Rgb);

 /* NULL Pallete */
 ZeroRGB();

 /* Set BackGround */
 for(y = 1; y < 21; y++)
    for(x = 0; x < 10*320; x++, Video++)
      *Video = (char)y;

 /* Write Credits & Game Name To Screen */
 Write_To_Screen(95, 5, 1, (char far *)0xA0000000,"SPACE INVADERS", 4, 1);
 Write_To_Screen(50, 160, 1,
		(char far *)0xA0000000, "Toby Opferman  (c)1997", 4, 1);

 /* Draw Shadow For Box */
 Video = (char far *)0xA0000000;
 Video+= 55*320+100;

 for(y = 0; y< 100; y++, Video+=320)
   _fmemset(Video, 0, 150);

 /* Draw The Box */
 Video = (char far *)0xA0000000;
 Video+= 50*320+90;

 for(y = 0; y< 100; y++, Video+=320)
   _fmemset(Video, 4, 150);

 /* Write Game Options To Screen */
 Write_To_Screen(100, 60, 1, (char far *)0xA0000000, " PLAY  GAME", 2, 1);
 Write_To_Screen(100, 90, 1, (char far *)0xA0000000, "INSTRUCTIONS", 2, 1);
 Write_To_Screen(100, 120, 1, (char far *)0xA0000000,"    QUIT", 2, 1);

 /* Fade Screen In */
 VRetrace();

 while(!FadeIn1(Rgb))
 {
    delay(10);
    VRetrace();
 }

}