			/*-=-=-=-=-=-=-=-=-=-*
			     Toby Opferman
			    VGA Functions
			 *-=-=-=-=-=-=-=-=-=-*/

 #include <conio.h>
 #include <stdlib.h>

 /* Set GFX Mode To 320x200x256 */
 void GFXMode(void)
{
   asm {
	 MOV AX, 0x13
	 INT 0x10
   }
}

 /* Set Text Mode 80x25 */
 void TextMode(void)
{
   asm {
	 MOV AX, 0x03
	 INT 0x10
   }
}

 /* Fade From Black To Correct Colors */
 int FadeIn1(RGB *P)
{
 int Done = 1, x;
 char R, G, B;

 for(x = 0; x < 256; x++)
 {
   outp(0x3C7, x);

   R = inp(0x3C9);
   G = inp(0x3C9);
   B = inp(0x3C9);

   if(R != P[x].R)
   {
      Done = 0;
      R++;
   }

   if(G != P[x].G)
   {
      Done = 0;
      G++;
   }

   if(B != P[x].B)
   {
      Done = 0;
      B++;
   }

   outp(0x3C8, x);

   outp(0x3C9, R);
   outp(0x3C9, G);
   outp(0x3C9, B);
 }

 return Done;
}

 /* Fade From White To Correct Colors */
 int FadeIn2(RGB *P)
{
 int Done = 1, x;
 char R, G, B;

 for(x = 0; x < 256; x++)
 {
   outp(0x3C7, x);

   R = inp(0x3C9);
   G = inp(0x3C9);
   B = inp(0x3C9);

   if(R != P[x].R)
   {
      Done = 0;
      R--;
   }

   if(G != P[x].G)
   {
      Done = 0;
      G--;
   }

   if(B != P[x].B)
   {
      Done = 0;
      B--;
   }

   outp(0x3C8, x);

   outp(0x3C9, R);
   outp(0x3C9, G);
   outp(0x3C9, B);
 }

 return Done;
}


 /* Fade To Black */
 int FadeOut(void)
{
 int Done = 1, x;
 char R, G, B;

 for(x = 0; x < 256; x++)
 {
   outp(0x3C7, x);

   R = inp(0x3C9);
   G = inp(0x3C9);
   B = inp(0x3C9);

   if(R)
   {
      Done = 0;
      R--;
   }

   if(G)
   {
      Done = 0;
      G--;
   }

   if(B)
   {
      Done = 0;
      B--;
   }

   outp(0x3C8, x);

   outp(0x3C9, R);
   outp(0x3C9, G);
   outp(0x3C9, B);
 }

 return Done;
}


 /* Fade To White */
 int FadeWhite(void)
{
 int Done = 1, x;
 char R, G, B;

 for(x = 0; x < 256; x++)
 {
   outp(0x3C7, x);

   R = inp(0x3C9);
   G = inp(0x3C9);
   B = inp(0x3C9);

   if(R != 63)
   {
      Done = 0;
      R++;
   }

   if(G != 63)
   {
      Done = 0;
      G++;
   }

   if(B != 63)
   {
      Done = 0;
      B++;
   }

   outp(0x3C8, x);

   outp(0x3C9, R);
   outp(0x3C9, G);
   outp(0x3C9, B);
 }

  return Done;
}



 /* Set Pallete */
 void SetRGB(RGB *P)
{
 int x;

 for(x = 0; x < 256; x++)
 {

   outp(0x3C8, x);

   outp(0x3C9, P[x].R);
   outp(0x3C9, P[x].G);
   outp(0x3C9, P[x].B);
 }

}

 /* Clear Pallete */
 void ZeroRGB(void)
{
 int x;

 for(x = 0; x < 256; x++)
 {

   outp(0x3C8, x);

   outp(0x3C9, 0);
   outp(0x3C9, 0);
   outp(0x3C9, 0);
 }

}


 /* Get Pallete */
 void GetRGB(RGB *P)
{
 int x;

 for(x = 0; x < 256; x++)
 {

   outp(0x3C7, x);

   P[x].R = inp(0x3C9);
   P[x].G = inp(0x3C9);
   P[x].B = inp(0x3C9);
 }

}


 /* Wait For Video Retrace */
 void VRetrace(void)
{
 asm  MOV DX, 0x3DA

 FIRST:
 asm {
       IN AL, DX
       TEST AL, 0x08
       JNZ SHORT FIRST
 }

 SECOND:
 asm {
       IN AL, DX
       TEST AL, 0x08
       JZ SHORT SECOND
 }
}

 /* Display SIZE Letters To Screen (String)*/
 void Write_To_Screen(int x, int y, char Colour, char far *Buff, const char *String, int SIZE, int Shadow)
{
 while(*String)
 {
     if(Shadow)
      blit_char(5 + x, y + 5, *String, Buff, 0, SIZE);

     blit_char(x , y, *String, Buff, Colour, SIZE);

     x+= 10;
     String++;
 }
}


 /* Write SIZE Characters To Screen */
 void blit_char(int xc, int yc, char c, char far *Vbuff, int Trans_Flag, int SIZE)
{

 int offset, x, y;
 int Colour;
 unsigned char far *work_char;
 unsigned char bit_mask = 0x80;
 unsigned char far *rom_char_set = (unsigned char far *)0xF000FA6E;


 if (!Trans_Flag)
   Colour = 0;
 else
 {
   if(Trans_Flag > 1)
      Colour = Trans_Flag;
   else
      Colour = c;
 }

 work_char = rom_char_set + c * 8;

 offset = (yc * 320) + xc;



 for (y = 0; y < 8; y++)
 {
     for(int TempLoop = 0; TempLoop < SIZE; TempLoop++)
     {
       bit_mask = 0x80;
       for(x = 0; x < 8; x++)
       {
	  if((*work_char & bit_mask))
	   *(Vbuff + offset + x) = (unsigned char)Colour;

	  bit_mask = (char)(bit_mask>>1);
       }

       if (Trans_Flag == 1)
       {
	 if ((rand() % 2))
	   Colour--;
	 else
	   Colour++;

	 if (Colour >= 256 || Colour <= 0)
	   Colour = (rand() % 254) + 1;
       }
       offset+= 320;
     }
     work_char++;
 }

}

 /* Display Exit Error Message */
 void ERROR(char Msg)
{
  char *X[] = {"Out Of Memory", "No Mouse Detected",
	       "File Not Found" };
  char *X2;
  int Y2;

  /* Grab Correct Error Message To Display */
  X2 = X[Msg];
  Y2 = strlen(X[Msg]);

  /* Switch To Text Mode */
  TextMode();

  /* Draw Box */
  asm {
	MOV AX, 0xB800
	MOV ES, AX
	MOV AH, 0x09
	MOV AL, 177
	MOV CX, 2000
	XOR DI, DI
	REP STOSW
	MOV DI, (9*160) + (25*2)
	MOV AX, 0x4F00
	MOV BX, 5
  }
  LOOP_HERE:
  asm {
	MOV CX, 20
	REP STOSW
	CMP BX, 4
	JA SHORT N
	MOV WORD PTR ES:[DI], 0
  }
  N:
  asm {
	ADD DI, 120
	DEC BX
	JNZ SHORT LOOP_HERE
	ADD DI, 2
	XOR AX, AX
	MOV CX, 20
	REP STOSW
	MOV DI, (11*160) + (27*2)
	MOV SI, X2
	MOV CX, Y2
  }
  P:
  asm {
	MOVSB
	INC DI
	LOOP SHORT P
  }

  /* Place Cursor at Bottom Of Screen & Exit */
  gotoxy(5,23);
  exit(0xFF);
}
