                              /*-=-=-=-=-=-=-=-*
                                Toby Opferman
                                  3-D Wire
                                  Graphics
                                  Library
                               *-=-=-=-=-=-=-=-*/


#ifndef __WIRE_H__

#define __WIRE_H__

 /* Header Files */
 #include <math.h>
 
 #define PI 3.14159265359

 /* Data Strucutres */

 typedef struct point_type {
     float x, y, z;
 } _3D_Point ;

 typedef struct off_type {
     int x, y, z;
 } _3D_Off ;

typedef struct obj_type {

    _3D_Point *P;
    _3D_Off OffSets;
    int MaxLines, *LinePairs, Points;
    char Colour;
    float Radians;

} _3D_Obj ;


 /* Prototypes */
 void ObjRotX(_3D_Obj *);
 void ObjRotY(_3D_Obj *);
 void ObjRotZ(_3D_Obj *);

 void Rotx(_3D_Point *, float);
 void Roty(_3D_Point *, float);
 void Rotz(_3D_Point *, float);
 
 float Rad(float);
 
 void ObjDraw(_3D_Obj *, char far *);
 void Line(int, int, int, int, char, char far *);

 #include "x\wire.c"

#endif
