/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman
  Winsock Client

 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/


/* Header Files */
#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <conio.h>

 /* Structures */
 typedef struct client_type {
     SOCKET hSocket;
     SOCKADDR_IN SockAddr;
     struct client_type *Next;
 } CLIENT;
 
 /* Prototypes */
 SOCKET ConnectClient(SOCKADDR_IN *);

 /* Main Function */
 int main(void)
{  
    WSADATA WsaData;
    SOCKET hSocket;
    SOCKADDR_IN SockAddr;
    int Ret, Retx;
    fd_set stReadFDS;
    struct timeval stTimeout;
    char Nick[12];
    char Buffer[1001];
    
    /* Initialize Winsock */
    if(WSAStartup(MAKEWORD(1, 1), &WsaData))
    {
       printf("WSAStartup() Error\n");
       return 0xFF;
    }
    printf("Toby Opferman's Synchronous Blocking Chat client\n");
    
    printf("Enter Your Name (Or A Nick Name, Max 11 Characters)\n");
    fgets(Nick, 12, stdin);
    
    if(Nick[strlen(Nick)-1] == '\n')
      Nick[strlen(Nick)-1] = 0;
      
    /* Connect Client */
    hSocket = ConnectClient(&SockAddr);
    
    sprintf(Buffer, "%s", Nick);
    if(send(hSocket, Buffer, strlen(Buffer), 0) == SOCKET_ERROR)
    {  
         printf("Socket Error Occured, Send() Aborted\n");
         closesocket(hSocket);
         WSACleanup();
         exit(0xFF);
    }
         
    printf("Client Type ~ to Quit, Or Just start typing to talk\n");
    while(1)
    {
        
       FD_ZERO(&stReadFDS);
       FD_SET(hSocket, &stReadFDS);

       stTimeout.tv_sec = 0;
       stTimeout.tv_usec = 1;
       
       Ret = select(0, &stReadFDS, NULL, NULL, &stTimeout);

       if((!Ret) || Ret == SOCKET_ERROR)
       {
           if(kbhit())
           {
               switch(getch())
               {
                   case '~' :
                   
                   goto DONE_CLIENT;
                   
                   default:
                      printf("Type Text (Max 256 Characters):\n");
                      sprintf(Buffer, "%s: ", Nick);
                      fgets(Buffer + strlen(Buffer), 256, stdin);
                      
                      if(send(hSocket, Buffer, strlen(Buffer), 0) == SOCKET_ERROR)
                          printf("Socket Error Occured, Send() Aborted\n");
                      
                   break;
               }
           }
           continue;
       }

       if(FD_ISSET(hSocket, &stReadFDS))
       {
           Retx = recv(hSocket, Buffer, 1000, 0);
           if((!Retx) || (Retx == SOCKET_ERROR))
           {
               printf("Server Closed\n");
               goto DONE_CLIENT;
           }
           
           Buffer[Retx] = 0;
           
           printf("%s\n", Buffer);
       }
        
    }

    DONE_CLIENT:
        
    /* Close Socket */
    closesocket(hSocket);
    
    /* Clean Up Winsock */
    if(WSACleanup() == SOCKET_ERROR)
        printf("WSACleanup() Error\n");
        

    return 0;
}

 /* Connect To Server */
 SOCKET ConnectClient(SOCKADDR_IN *SockAddr)
{
    SOCKET hSocket;
    char HostName[101];

    
    /* Create TCP Socket */ 
    if((hSocket = socket(PF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
    {
        printf("socket() Error\n");
        WSACleanup();
        exit(0xFF);
    }

    memset(SockAddr, 0, sizeof(struct sockaddr_in));
    
    /* Initialize Local Server */
    SockAddr->sin_family = PF_INET;
    SockAddr->sin_port = 4000;
    printf("Enter Host IP Address like: 128.0.0.0\n");
    fgets(HostName, 100, stdin);
    
    SockAddr->sin_addr.s_addr = inet_addr(HostName);
    
    /* Bind Socket */
    if((connect(hSocket, (LPSOCKADDR)SockAddr, sizeof(SOCKADDR_IN))) == SOCKET_ERROR)
    {
        printf("connect() Error\n");
        closesocket(hSocket);
        WSACleanup();
        exit(0xFF);
    }

    printf("Connected\n");
        
    /* Return Socket */
    return hSocket;

}
       



