/*-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*
  Toby Opferman
  Winsock Server

 *-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-*/


/* Header Files */
#include <windows.h>
#include <winsock.h>
#include <stdio.h>
#include <stdlib.h>
#include <mem.h>
#include <conio.h>

 /* Structures */
 typedef struct client_type {
     SOCKET hSocket;
     SOCKADDR_IN SockAddr;
     char Nick[12];
     int SetNick;
     struct client_type *Next;
 } CLIENT;
 
 /* Prototypes */
 SOCKET CreateServer(SOCKADDR_IN *);

 /* Main Function */
 int main(void)
{  
    WSADATA WsaData;
    SOCKET hSocket, ConnectSocket;
    SOCKADDR_IN SockAddr, ConnectAddr;
    int Len, Ret, Retx;
    CLIENT *Clients = NULL, *Runner, *Runner2;
    fd_set stReadFDS, stXcptFDS;
    struct timeval stTimeout;
    char Buffer[20000];
    
    /* Initialize Winsock */
    if(WSAStartup(MAKEWORD(1, 1), &WsaData))
    {
       printf("WSAStartup() Error\n");
       return 0xFF;
    }
    printf("Toby Opferman's Synchronous Blocking Chat server with 1 second delay\n");
    /* Create Server */
    hSocket = CreateServer(&SockAddr);

    printf("Server Started. 'Q' to quit server.\n");
    
    /* Server Loop */
    while(1)
    {
       FD_ZERO(&stReadFDS);
       FD_ZERO(&stXcptFDS);
       FD_SET(hSocket, &stReadFDS);
       
       Runner = Clients;
       while(Runner)
       {
         FD_SET(Runner->hSocket, &stReadFDS);
         Runner = Runner->Next;
       }
       
       stTimeout.tv_sec = 1;
       stTimeout.tv_usec = 0;
       
       Ret = select(0, &stReadFDS, NULL, &stXcptFDS, &stTimeout);

       if((!Ret) || Ret == SOCKET_ERROR)
       {
           if(kbhit())
           {
               switch(getch())
               {
                   case 'q' :
                   case 'Q' :
                   goto DONE_SERVER;
               }
           }
           continue;
       }


       if(FD_ISSET(hSocket, &stReadFDS))
       {
           Ret--;
           
            Len = sizeof(SOCKADDR_IN);


            
             /* Check Connections */
            if((ConnectSocket = accept(hSocket, (struct sockaddr *)&ConnectAddr, &Len)) != INVALID_SOCKET)
            {
                sprintf(Buffer, "People Connected: ");
                
                Runner = Clients;
                while(Runner)
                {
                    sprintf(Buffer, "%s %s", Buffer, Runner->Nick);
                    Runner = Runner->Next;
                }
                
               sprintf(Buffer, "%s\n", Buffer);
                
               send(ConnectSocket, Buffer, strlen(Buffer), 0);
               
               if(!Clients)
               {
                 if(!(Clients = (CLIENT *)malloc(sizeof(CLIENT))))
                 {
                     printf("Unable to Connect, Out Of Memory\n");
                     closesocket(ConnectSocket);
                 }
                 else
                 {

                     
                     Clients->Next = NULL;
                     Clients->hSocket = ConnectSocket;
                     Clients->SockAddr = ConnectAddr;
                     Clients->Nick[0] = 0;
                     Clients->SetNick = 0;
                     printf("Connected IP = %i.%i.%i.%i\n", Clients->SockAddr.sin_addr.s_addr&0xFF,
                                       Clients->SockAddr.sin_addr.s_addr>>8 & 0xFF,
                                       Clients->SockAddr.sin_addr.s_addr>>16 & 0xFF,
                                       Clients->SockAddr.sin_addr.s_addr>>24 & 0xFF);
                             
                     
                 }
              }
              else
              {
                 
                 Runner = Clients;

                 while(Runner->Next)
                   Runner = Runner->Next;
                   
                 if(!(Runner->Next = (CLIENT *)malloc(sizeof(CLIENT))))
                 {
                     printf("Unable To Connect, Out Of Memory\n");
                     closesocket(ConnectSocket);
                 }
                 else
                 {
                     Runner->Next->Next = NULL;
                     Runner->Next->hSocket = ConnectSocket;
                     Runner->Next->SockAddr = ConnectAddr;
                     
                     Runner->Next->Nick[0] = 0;
                     Runner->Next->SetNick = 0;
                     printf("Connected IP = %i.%i.%i.%i\n", Runner->Next->SockAddr.sin_addr.s_addr&0xFF,
                                       Runner->Next->SockAddr.sin_addr.s_addr>>8 & 0xFF,
                                       Runner->Next->SockAddr.sin_addr.s_addr>>16 & 0xFF,
                                       Runner->Next->SockAddr.sin_addr.s_addr>>24 & 0xFF);
                 }
             }
         }
       }

       
       Runner = Clients;
       while(Ret && Runner)
       {
           if(FD_ISSET(Runner->hSocket, &stReadFDS))
           {
               
               Retx = recv(Runner->hSocket, Buffer, 1000, 0);
               if(Retx == 0 || Retx == SOCKET_ERROR)
               {
                  
                   sprintf(Buffer, "***** %s Has Left the chat line\n", Runner->Nick);

                  Runner2 = Clients;
                  while(Runner2)
                  {
                    if(Runner2 != Runner)
                      send(Runner2->hSocket, Buffer, strlen(Buffer), 0);
                      
                    Runner2 = Runner2->Next;
                  }

                   printf("Closing Connection IP = %i.%i.%i.%i\n", Runner->SockAddr.sin_addr.s_addr&0xFF,
                                       Runner->SockAddr.sin_addr.s_addr>>8 & 0xFF,
                                       Runner->SockAddr.sin_addr.s_addr>>16 & 0xFF,
                                       Runner->SockAddr.sin_addr.s_addr>>24 & 0xFF);
                   closesocket(Runner->hSocket);
                   Runner2 = Clients;
                   if(Runner2 == Runner)
                   {
                       Clients = Clients->Next;
                       free(Runner);
                       Runner = Clients;
                   }
                   else
                   {
                       
                     while(Runner2->Next != Runner)
                         Runner2 = Runner2->Next;

                     if(Runner2->Next == Runner)
                     {
                         Runner2->Next = Runner->Next;
                         free(Runner);
                         Runner = Runner2;
                     }
                     
                     
                   }
                   
               }
               else
               {
                  if(!Runner->SetNick)
                  {
                      Buffer[Retx] = 0;
                      strcpy(Runner->Nick, Buffer);
                      sprintf(Buffer, "*** %s has joined the chat line\n", Runner->Nick);
                      Retx = strlen(Buffer);
                      Runner->SetNick = 1;
                      
                  }
             
                  Runner2 = Clients;
                  while(Runner2)
                  {
                    if(Runner2 != Runner)
                      send(Runner2->hSocket, Buffer, Retx, 0);

                    Runner2 = Runner2->Next;
                  }
             
               }
                      
               Ret--;
           }

           if(Runner)
             Runner = Runner->Next;
       }

    }
    
    DONE_SERVER:

    /* Close Sockets */
    while(Clients)
    {
        closesocket(Clients->hSocket);
        
        Runner = Clients->Next;
        Clients = Runner;
    }
        
    /* Close Socket */
    closesocket(hSocket);
    
    /* Clean Up Winsock */
    if(WSACleanup() == SOCKET_ERROR)
        printf("WSACleanup() Error\n");
        

    return 0;
}

 /* Create A Socket */
 SOCKET CreateServer(SOCKADDR_IN *SockAddr)
{
    SOCKET hSocket;
    char HostName[101];
    LPHOSTENT Host;
    
    /* Create TCP Socket */ 
    if((hSocket = socket(PF_INET, SOCK_STREAM, 0)) == INVALID_SOCKET)
    {
        printf("socket() Error\n");
        exit(0xFF);
    }

    memset(SockAddr, 0, sizeof(struct sockaddr_in));
    
    /* Initialize Local Server */
    SockAddr->sin_family = PF_INET;
    SockAddr->sin_port = 4000;
    
    /* Bind Socket */
    if(bind(hSocket, (struct sockaddr *)SockAddr, sizeof(SOCKADDR_IN)) == INVALID_SOCKET)
    {
        printf("bind() Error\n");
        exit(0xFF);
    }

    /* Listen Socket */
    if(listen(hSocket, 5))
    {
        printf("listen() Error\n");
        exit(0xFF);
    }



    if(!SockAddr->sin_addr.s_addr)
    {
          if(gethostname(HostName, 100) == SOCKET_ERROR)
          {
             closesocket(hSocket);
             printf("Cannot Find Local IP\n");
             return 0;
          }

          Host = gethostbyname((LPSTR)HostName);
                                 
          if(Host)
            SockAddr->sin_addr.s_addr = *((long *)Host->h_addr);
                                           
          if(!SockAddr->sin_addr.s_addr)
          {
            closesocket(hSocket);
            printf("Cannot Find Local IP\n");                  
            return 0;
          }
                                
    }
     
           
    /* Connected Print Server Info */
    printf("Local IP = %i.%i.%i.%i\n", SockAddr->sin_addr.s_addr&0xFF,
                                       SockAddr->sin_addr.s_addr>>8 & 0xFF,
                                       SockAddr->sin_addr.s_addr>>16 & 0xFF,
                                       SockAddr->sin_addr.s_addr>>24 & 0xFF);
                                       
    printf("Port Number = %i\n", SockAddr->sin_port);
    
    /* Return Socket */
    return hSocket;

}
       



