/***********************************************************************
 * Tile.h
 *  
 *    Tile Scroller API
 *
 *
 * Toby Opferman Copyright (c) 2003
 *
 ***********************************************************************/


#ifndef __TILE_H__
#define __TILE_H__


typedef PVOID HTILE;


typedef void (WINAPI *PFNDRAWTILE)(PVOID pContext, DWORD dwTileId, UINT dwTileX, UINT dwTileY, UINT dwStartX, UINT dwStartY);
typedef void (WINAPI *PFNTILECALLBACK)(PVOID pContext, DWORD dwTileCallBackId);

#define TF_CALLBACK  0x1  /* Moving On This Tile Gets A Call Back */

#define TF_BLOCKED   0x2  /* This Tile is Blocked From Movement */

typedef struct {
    
    DWORD dwTileId;

    DWORD dwTileFlags;

	DWORD dwTileCallBackId;
    PVOID pTileCallbackContext;
    PFNTILECALLBACK pfnTileCallback;
    
} TILEINFO, *PTILEINFO;

typedef struct {

    PVOID       pTileContext;
    PFNDRAWTILE pfnDrawTile;

	DWORD dwResolutionX;
	DWORD dwResolutionY;

	DWORD dwTileSizeX;
	DWORD dwTileSizeY;

    PTILEINFO pTileInfo;

} TILE_MAP, *PTILE_MAP;



#ifdef __cplusplus
extern "C" {
#endif

HTILE WINAPI Tile_Init(PTILE_MAP pTileMap);
void WINAPI Tile_UnInit(HTILE hTile);

BOOL WINAPI Tile_MoveUp(HTILE hTile, DWORD dwPosition);
BOOL WINAPI Tile_MoveDown(HTILE hTile, DWORD dwPosition);
BOOL WINAPI Tile_MoveLeft(HTILE hTile, DWORD dwPosition);
BOOL WINAPI Tile_MoveRight(HTILE hTile, DWORD dwPosition);
void WINAPI Tile_Draw(HTILE hTile, UINT dwMaxX, UINT dwMaxY);

#ifdef __cplusplus
}
#endif



#endif

